/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.Arrays4;
import com.db4o.foundation.BitMap4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.handlers.LongHandler;

public class ByteArrayBuffer
implements ReadWriteBuffer {
    public byte[] _buffer;
    public int _offset;

    ByteArrayBuffer() {
    }

    public ByteArrayBuffer(int length) {
        this._buffer = new byte[length];
    }

    public ByteArrayBuffer(byte[] buffer) {
        this._buffer = buffer;
    }

    public void seek(int offset) {
        this._offset = offset;
    }

    public void writeBytes(byte[] bytes) {
        System.arraycopy(bytes, 0, this._buffer, this._offset, bytes.length);
        this._offset += bytes.length;
    }

    public void append(byte[] bytes) {
        this.writeBytes(bytes);
    }

    public final boolean containsTheSame(ByteArrayBuffer other) {
        if (other != null) {
            return Arrays4.equals(this._buffer, other._buffer);
        }
        return false;
    }

    public void copyTo(ByteArrayBuffer to, int fromOffset, int toOffset, int length) {
        System.arraycopy(this._buffer, fromOffset, to._buffer, toOffset, length);
    }

    public int length() {
        return this._buffer.length;
    }

    public void incrementOffset(int a_by) {
        this._offset += a_by;
    }

    public void read(ObjectContainerBase stream, int address, int addressOffset) {
        stream.readBytes(this._buffer, address, addressOffset, this.length());
    }

    public final void readBegin(byte identifier) {
    }

    public BitMap4 readBitMap(int bitCount) {
        BitMap4 map = new BitMap4(this._buffer, this._offset, bitCount);
        this._offset += map.marshalledLength();
        return map;
    }

    public byte readByte() {
        return this._buffer[this._offset++];
    }

    public byte[] readBytes(int a_length) {
        byte[] bytes = new byte[a_length];
        this.readBytes(bytes);
        return bytes;
    }

    public void readBytes(byte[] bytes) {
        int length = bytes.length;
        System.arraycopy(this._buffer, this._offset, bytes, 0, length);
        this._offset += length;
    }

    public final ByteArrayBuffer readEmbeddedObject(Transaction trans) throws Db4oIOException {
        int address = this.readInt();
        int length = this.readInt();
        if (address == 0) {
            return null;
        }
        return trans.container().decryptedBufferByAddress(address, length);
    }

    public void readEncrypt(ObjectContainerBase stream, int address) throws Db4oIOException {
        stream.readBytes(this._buffer, address, this.length());
        stream._handlers.decrypt(this);
    }

    public void readEnd() {
    }

    public final int readInt() {
        int o = (this._offset += 4) - 1;
        return this._buffer[o] & 0xFF | (this._buffer[--o] & 0xFF) << 8 | (this._buffer[--o] & 0xFF) << 16 | this._buffer[--o] << 24;
    }

    public long readLong() {
        return LongHandler.readLong(this);
    }

    public ByteArrayBuffer readPayloadReader(int offset, int length) {
        ByteArrayBuffer payLoad = new ByteArrayBuffer(length);
        System.arraycopy(this._buffer, offset, payLoad._buffer, 0, length);
        return payLoad;
    }

    void replaceWith(byte[] a_bytes) {
        System.arraycopy(a_bytes, 0, this._buffer, 0, this.length());
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this._buffer.length; ++i) {
            if (i > 0) {
                str = str + " , ";
            }
            str = str + this._buffer[i];
        }
        return str;
    }

    public void writeBegin(byte a_identifier) {
    }

    public final void writeBitMap(BitMap4 nullBitMap) {
        nullBitMap.writeTo(this._buffer, this._offset);
        this._offset += nullBitMap.marshalledLength();
    }

    public final void writeByte(byte a_byte) {
        this._buffer[this._offset++] = a_byte;
    }

    public void writeEnd() {
    }

    public final void writeInt(int a_int) {
        int o = this._offset + 4;
        this._offset = o--;
        byte[] b = this._buffer;
        b[o] = (byte)a_int;
        b[--o] = (byte)(a_int >>= 8);
        b[--o] = (byte)(a_int >>= 8);
        b[--o] = (byte)(a_int >> 8);
    }

    public void writeIDOf(Transaction trans, Object obj) {
        if (obj == null) {
            this.writeInt(0);
            return;
        }
        if (obj instanceof PersistentBase) {
            this.writeIDOf(trans, (PersistentBase)obj);
            return;
        }
        this.writeInt((Integer)obj);
    }

    public void writeIDOf(Transaction trans, PersistentBase persistent) {
        if (persistent == null) {
            this.writeInt(0);
            return;
        }
        if (this.canWritePersistentBase()) {
            persistent.writeOwnID(trans, this);
        } else {
            this.writeInt(persistent.getID());
        }
    }

    protected boolean canWritePersistentBase() {
        return true;
    }

    public void writeShortString(Transaction trans, String a_string) {
        trans.container()._handlers._stringHandler.writeShort(trans, a_string, this);
    }

    public void writeLong(long l) {
        LongHandler.writeLong(this, l);
    }

    public void incrementIntSize() {
        this.incrementOffset(4);
    }

    public int offset() {
        return this._offset;
    }

    public void ensureSize(int size) {
        if (size == this._buffer.length) {
            return;
        }
        this._buffer = new byte[size];
    }

    public void skip(int length) {
        this.seek(this._offset + length);
    }
}

