/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.foundation.Collection4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.LinkLengthAware;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Persistent;
import com.db4o.internal.Transaction;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;

public abstract class PersistentBase
implements Persistent,
LinkLengthAware {
    protected int _id;
    protected int _state = 2;

    public final boolean beginProcessing() {
        if (this.bitIsTrue(2)) {
            return false;
        }
        this.bitTrue(2);
        return true;
    }

    final void bitFalse(int bitPos) {
        this._state &= ~(1 << bitPos);
    }

    final boolean bitIsFalse(int bitPos) {
        return (this._state | 1 << bitPos) != this._state;
    }

    final boolean bitIsTrue(int bitPos) {
        return (this._state | 1 << bitPos) == this._state;
    }

    final void bitTrue(int bitPos) {
        this._state |= 1 << bitPos;
    }

    void cacheDirty(Collection4 col) {
        if (!this.bitIsTrue(3)) {
            this.bitTrue(3);
            col.add(this);
        }
    }

    public void endProcessing() {
        this.bitFalse(2);
    }

    public void free(Transaction trans) {
        trans.systemTransaction().slotFreePointerOnCommit(this.getID());
    }

    public int getID() {
        return this._id;
    }

    public final boolean isActive() {
        return this.bitIsTrue(1);
    }

    public boolean isDirty() {
        return this.bitIsTrue(1) && !this.bitIsTrue(0);
    }

    public final boolean isNew() {
        return this.getID() == 0;
    }

    public final int linkLength() {
        return 4;
    }

    final void notCachedDirty() {
        this.bitFalse(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Transaction trans) {
        if (!this.beginProcessing()) {
            return;
        }
        try {
            ByteArrayBuffer reader = this.produceReadBuffer(trans);
            this.readThis(trans, reader);
            this.setStateOnRead(reader);
        }
        finally {
            this.endProcessing();
        }
    }

    protected ByteArrayBuffer produceReadBuffer(Transaction trans) {
        return this.readBufferById(trans);
    }

    protected ByteArrayBuffer readBufferById(Transaction trans) {
        return trans.container().readReaderByID(trans, this.getID());
    }

    public void setID(int a_id) {
        if (DTrace.enabled) {
            DTrace.PERSISTENTBASE_SET_ID.log(a_id);
        }
        this._id = a_id;
    }

    public final void setStateClean() {
        this.bitTrue(1);
        this.bitTrue(0);
    }

    public final void setStateDeactivated() {
        this.bitFalse(1);
    }

    public void setStateDirty() {
        this.bitTrue(1);
        this.bitFalse(0);
    }

    void setStateOnRead(ByteArrayBuffer reader) {
        if (this.bitIsTrue(3)) {
            this.setStateDirty();
        } else {
            this.setStateClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Transaction trans) {
        if (!this.writeObjectBegin()) {
            return;
        }
        try {
            Slot slot;
            LocalObjectContainer stream = (LocalObjectContainer)trans.container();
            if (DTrace.enabled) {
                DTrace.PERSISTENT_OWN_LENGTH.log(this.getID());
            }
            int length = this.ownLength();
            length = stream.blockAlignedBytes(length);
            if (this.isNew()) {
                Pointer4 pointer = stream.newSlot(length);
                this.setID(pointer._id);
                slot = pointer._slot;
                trans.setPointer(pointer);
            } else {
                slot = stream.getSlot(length);
                trans.slotFreeOnRollbackCommitSetPointer(this._id, slot, this.isFreespaceComponent());
            }
            ByteArrayBuffer writer = this.produceWriteBuffer(trans, length);
            this.writeToFile(trans, writer, slot);
        }
        finally {
            this.endProcessing();
        }
    }

    protected ByteArrayBuffer produceWriteBuffer(Transaction trans, int length) {
        return this.newWriteBuffer(length);
    }

    protected ByteArrayBuffer newWriteBuffer(int length) {
        return new ByteArrayBuffer(length);
    }

    public boolean isFreespaceComponent() {
        return false;
    }

    private final void writeToFile(Transaction trans, ByteArrayBuffer writer, Slot slot) {
        if (DTrace.enabled) {
            DTrace.PERSISTENTBASE_WRITE.log(this.getID());
        }
        LocalObjectContainer container = (LocalObjectContainer)trans.container();
        this.writeThis(trans, writer);
        container.writeEncrypt(writer, slot.address(), 0);
        if (this.isActive()) {
            this.setStateClean();
        }
    }

    public boolean writeObjectBegin() {
        if (this.isDirty()) {
            return this.beginProcessing();
        }
        return false;
    }

    public void writeOwnID(Transaction trans, ByteArrayBuffer writer) {
        this.write(trans);
        writer.writeInt(this.getID());
    }

    public int hashCode() {
        if (this.isNew()) {
            throw new IllegalStateException();
        }
        return this.getID();
    }
}

