/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.internal.Config4Impl;
import com.db4o.typehandlers.IgnoreFieldsTypeHandler;
import com.db4o.typehandlers.SingleClassTypeHandlerPredicate;
import com.db4o.typehandlers.TypeHandler4;

public abstract class TypeHandlerConfiguration {
    protected final Config4Impl _config;
    private TypeHandler4 _listTypeHandler;
    private TypeHandler4 _mapTypeHandler;

    public abstract void apply();

    public TypeHandlerConfiguration(Config4Impl config) {
        this._config = config;
    }

    protected void listTypeHandler(TypeHandler4 listTypeHandler) {
        this._listTypeHandler = listTypeHandler;
    }

    protected void mapTypeHandler(TypeHandler4 mapTypehandler) {
        this._mapTypeHandler = mapTypehandler;
    }

    protected void registerCollection(Class clazz) {
        this.registerListTypeHandlerFor(clazz);
    }

    protected void registerMap(Class clazz) {
        this.registerMapTypeHandlerFor(clazz);
    }

    protected void ignoreFieldsOn(Class clazz) {
        this._config.registerTypeHandler(new SingleClassTypeHandlerPredicate(clazz), IgnoreFieldsTypeHandler.INSTANCE);
    }

    private void registerListTypeHandlerFor(Class clazz) {
        this.registerTypeHandlerFor(clazz, this._listTypeHandler);
    }

    private void registerMapTypeHandlerFor(Class clazz) {
        this.registerTypeHandlerFor(clazz, this._mapTypeHandler);
    }

    protected void registerTypeHandlerFor(Class clazz, TypeHandler4 typeHandler) {
        this._config.registerTypeHandler(new SingleClassTypeHandlerPredicate(clazz), typeHandler);
    }
}

