/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.caching;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.CircularBuffer4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.Iterable4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.Procedure4;
import com.db4o.internal.caching.Cache4;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LRU2QXCache<K, V>
implements Cache4<K, V> {
    private final Map<K, V> _slots;
    private final CircularBuffer4<K> _am;
    private final CircularBuffer4<K> _a1in;
    private final CircularBuffer4<K> _a1out;
    private final int _maxSize;
    private final int _inSize;

    public LRU2QXCache(int maxSize) {
        this._maxSize = maxSize;
        this._inSize = this._maxSize / 4;
        this._slots = new HashMap(this._maxSize);
        this._am = new CircularBuffer4(this._maxSize);
        this._a1in = new CircularBuffer4(this._maxSize);
        this._a1out = new CircularBuffer4(this._maxSize / 2);
    }

    @Override
    public V produce(K key, Function4<K, V> producer, Procedure4<V> finalizer) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this._am.remove(key)) {
            this._am.addFirst(key);
            return this._slots.get(key);
        }
        if (this._a1out.contains(key)) {
            this.reclaimFor(key, producer, finalizer);
            this._am.addFirst(key);
            return this._slots.get(key);
        }
        if (this._a1in.contains(key)) {
            return this._slots.get(key);
        }
        this.reclaimFor(key, producer, finalizer);
        this._a1in.addFirst(key);
        return this._slots.get(key);
    }

    private void reclaimFor(K key, Function4<K, V> producer, Procedure4<V> finalizer) {
        if (this._slots.size() < this._maxSize) {
            this._slots.put(key, producer.apply(key));
            return;
        }
        if (this._a1in.size() > this._inSize) {
            K lastKey = this._a1in.removeLast();
            this.discard(lastKey, finalizer);
            if (this._a1out.isFull()) {
                this._a1out.removeLast();
            }
            this._a1out.addFirst(lastKey);
        } else {
            K lastKey = this._am.removeLast();
            this.discard(lastKey, finalizer);
        }
        this._slots.put(key, producer.apply(key));
    }

    @Override
    public Iterator iterator() {
        return this._slots.values().iterator();
    }

    public String toString() {
        return "LRU2QXCache(am=" + this.toString(this._am) + ", a1in=" + this.toString(this._a1in) + ", a1out=" + this.toString(this._a1out) + ")" + " - " + this._slots.size();
    }

    private void discard(K key, Procedure4<V> finalizer) {
        V removed = this._slots.remove(key);
        if (finalizer != null) {
            finalizer.apply(removed);
        }
    }

    private String toString(Iterable4<K> buffer) {
        return Iterators.toString(buffer);
    }
}

