/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.DTrace;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.PersistentIntegerArray;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeNodeSearchResult;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.SearchTarget;
import com.db4o.internal.freespace.AbstractFreespaceManager;
import com.db4o.internal.freespace.AddressKeySlotHandler;
import com.db4o.internal.freespace.FreespaceBTree;
import com.db4o.internal.freespace.FreespaceListener;
import com.db4o.internal.freespace.LengthKeySlotHandler;
import com.db4o.internal.freespace.NullFreespaceListener;
import com.db4o.internal.freespace.RamFreespaceManager;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;

public class BTreeFreespaceManager
extends AbstractFreespaceManager {
    private RamFreespaceManager _delegate;
    private FreespaceBTree _slotsByAddress;
    private FreespaceBTree _slotsByLength;
    private PersistentIntegerArray _idArray;
    private int _delegateIndirectionID;
    private int _delegationRequests;
    private FreespaceListener _listener = NullFreespaceListener.INSTANCE;

    public BTreeFreespaceManager(LocalObjectContainer file) {
        super(file);
        this._delegate = new RamFreespaceManager(file);
    }

    private void addSlot(Slot slot) {
        this._slotsByLength.add(this.transaction(), slot);
        this._slotsByAddress.add(this.transaction(), slot);
        this._listener.slotAdded(slot.length());
    }

    public Slot allocateTransactionLogSlot(int length) {
        return this._delegate.allocateTransactionLogSlot(length);
    }

    public void beginCommit() {
        this.beginDelegation();
    }

    private void beginDelegation() {
        ++this._delegationRequests;
    }

    public void commit() {
        this._slotsByAddress.commit(this.transaction());
        this._slotsByLength.commit(this.transaction());
    }

    private void createBTrees(int addressID, int lengthID) {
        this._slotsByAddress = new FreespaceBTree(this.transaction(), addressID, new AddressKeySlotHandler());
        this._slotsByLength = new FreespaceBTree(this.transaction(), lengthID, new LengthKeySlotHandler());
    }

    public void endCommit() {
        this.endDelegation();
    }

    private void endDelegation() {
        --this._delegationRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Slot slot) {
        if (!this.started()) {
            return;
        }
        if (this.isDelegating()) {
            this._delegate.free(slot);
            return;
        }
        try {
            Slot nextSlot;
            Slot previousSlot;
            BTreePointer previousPointer;
            this.beginDelegation();
            if (DTrace.enabled) {
                DTrace.FREESPACEMANAGER_BTREE_FREE.logLength(slot.address(), slot.length());
            }
            Slot[] remove = new Slot[2];
            Slot newFreeSlot = slot;
            BTreePointer pointer = this.searchBTree(this._slotsByAddress, slot, SearchTarget.LOWEST);
            BTreePointer bTreePointer = previousPointer = pointer != null ? pointer.previous() : this._slotsByAddress.lastPointer(this.transaction());
            if (previousPointer != null && (previousSlot = (Slot)previousPointer.key()).isDirectlyPreceding(newFreeSlot)) {
                remove[0] = previousSlot;
                newFreeSlot = previousSlot.append(newFreeSlot);
            }
            if (pointer != null && newFreeSlot.isDirectlyPreceding(nextSlot = (Slot)pointer.key())) {
                remove[1] = nextSlot;
                newFreeSlot = newFreeSlot.append(nextSlot);
            }
            for (int i = 0; i < remove.length; ++i) {
                if (remove[i] == null) continue;
                this.removeSlot(remove[i]);
            }
            if (!this.canDiscard(newFreeSlot.length())) {
                this.addSlot(newFreeSlot);
            }
            this._file.overwriteDeletedBlockedSlot(slot);
        }
        finally {
            this.endDelegation();
        }
    }

    public void freeSelf() {
        this._slotsByAddress.free(this.transaction());
        this._slotsByLength.free(this.transaction());
    }

    public void freeTransactionLogSlot(Slot slot) {
        this._delegate.freeTransactionLogSlot(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slot getSlot(int length) {
        if (!this.started()) {
            return null;
        }
        if (this.isDelegating()) {
            return this._delegate.getSlot(length);
        }
        try {
            this.beginDelegation();
            BTreePointer pointer = this.searchBTree(this._slotsByLength, new Slot(0, length), SearchTarget.HIGHEST);
            if (pointer == null) {
                Slot slot = null;
                return slot;
            }
            Slot slot = (Slot)pointer.key();
            this.removeSlot(slot);
            int remainingLength = slot.length() - length;
            if (!this.canDiscard(remainingLength)) {
                this.addSlot(slot.subSlot(length));
                slot = slot.truncate(length);
            }
            if (DTrace.enabled) {
                DTrace.FREESPACEMANAGER_GET_SLOT.logLength(slot.address(), slot.length());
            }
            Slot slot2 = slot;
            return slot2;
        }
        finally {
            this.endDelegation();
        }
    }

    private void initializeExisting(int slotAddress) {
        this._idArray = new PersistentIntegerArray(slotAddress);
        this._idArray.read(this.transaction());
        int[] ids = this._idArray.array();
        int addressId = ids[0];
        int lengthID = ids[1];
        this._delegateIndirectionID = ids[2];
        this.createBTrees(addressId, lengthID);
        this._slotsByAddress.read(this.transaction());
        this._slotsByLength.read(this.transaction());
        Pointer4 delegatePointer = this.transaction().readPointer(this._delegateIndirectionID);
        this.transaction().writeZeroPointer(this._delegateIndirectionID);
        this.transaction().flushFile();
        this._delegate.read(delegatePointer._slot);
    }

    private void initializeNew() {
        this.createBTrees(0, 0);
        this._slotsByAddress.write(this.transaction());
        this._slotsByLength.write(this.transaction());
        this._delegateIndirectionID = this._file.getPointerSlot();
        int[] ids = new int[]{this._slotsByAddress.getID(), this._slotsByLength.getID(), this._delegateIndirectionID};
        this._idArray = new PersistentIntegerArray(ids);
        this._idArray.write(this.transaction());
        this._file.systemData().freespaceAddress(this._idArray.getID());
    }

    private boolean isDelegating() {
        return this._delegationRequests > 0;
    }

    public void read(int freeSpaceID) {
    }

    private void removeSlot(Slot slot) {
        this._slotsByLength.remove(this.transaction(), slot);
        this._slotsByAddress.remove(this.transaction(), slot);
        this._listener.slotRemoved(slot.length());
    }

    private BTreePointer searchBTree(BTree bTree, Slot slot, SearchTarget target) {
        BTreeNodeSearchResult searchResult = bTree.searchLeaf((Transaction)this.transaction(), slot, target);
        return searchResult.firstValidPointer();
    }

    public int slotCount() {
        return this._slotsByAddress.size(this.transaction()) + this._delegate.slotCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int slotAddress) {
        try {
            this.beginDelegation();
            if (slotAddress == 0) {
                this.initializeNew();
            } else {
                this.initializeExisting(slotAddress);
            }
        }
        finally {
            this.endDelegation();
        }
    }

    private boolean started() {
        return this._idArray != null;
    }

    public byte systemType() {
        return 4;
    }

    public String toString() {
        return this._slotsByLength.toString();
    }

    public int totalFreespace() {
        return super.totalFreespace() + this._delegate.totalFreespace();
    }

    public void traverse(Visitor4 visitor) {
        this._slotsByAddress.traverseKeys(this.transaction(), visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write() {
        try {
            this.beginDelegation();
            Slot slot = this._file.getSlot(this._delegate.marshalledLength());
            Pointer4 pointer = new Pointer4(this._delegateIndirectionID, slot);
            this._delegate.write(pointer);
            int n = this._idArray.getID();
            return n;
        }
        finally {
            this.endDelegation();
        }
    }

    public void listener(FreespaceListener listener) {
        this._listener = listener;
    }
}

