/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ids;

import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.ids.IdSystem;
import com.db4o.internal.ids.TransactionLogHandler;
import com.db4o.internal.slots.Slot;

public class EmbeddedTransactionLogHandler
extends TransactionLogHandler {
    private int _addressOfIncompleteCommit;

    public boolean checkForInterruptedTransaction(IdSystem idSystem, ByteArrayBuffer reader) {
        int transactionID1 = reader.readInt();
        int transactionID2 = reader.readInt();
        if (transactionID1 > 0 && transactionID1 == transactionID2) {
            this._addressOfIncompleteCommit = transactionID1;
            return true;
        }
        return false;
    }

    public void completeInterruptedTransaction(IdSystem idSystem) {
        StatefulBuffer bytes = new StatefulBuffer(idSystem.systemTransaction(), this._addressOfIncompleteCommit, 4);
        bytes.read();
        int length = bytes.readInt();
        if (length > 0) {
            bytes = new StatefulBuffer(idSystem.systemTransaction(), this._addressOfIncompleteCommit, length);
            bytes.read();
            bytes.incrementOffset(4);
            idSystem.readSlotChanges(bytes);
            if (idSystem.writeSlots()) {
                this.flushDatabaseFile(idSystem);
            }
            this.file(idSystem).writeTransactionPointer(0);
            this.flushDatabaseFile(idSystem);
            idSystem.freeSlotChanges(false);
        } else {
            this.file(idSystem).writeTransactionPointer(0);
            this.flushDatabaseFile(idSystem);
        }
    }

    public Slot allocateSlot(IdSystem idSystem, boolean appendToFile) {
        int blockedLength;
        Slot slot;
        int transactionLogByteCount = this.transactionLogSlotLength(idSystem);
        FreespaceManager freespaceManager = idSystem.freespaceManager();
        if (!appendToFile && freespaceManager != null && (slot = freespaceManager.allocateTransactionLogSlot(blockedLength = this.file(idSystem).bytesToBlocks(transactionLogByteCount))) != null) {
            return this.file(idSystem).toNonBlockedLength(slot);
        }
        return this.file(idSystem).appendBytes(transactionLogByteCount);
    }

    private void freeSlot(IdSystem idSystem, Slot slot) {
        if (slot == null) {
            return;
        }
        if (idSystem.freespaceManager() == null) {
            return;
        }
        idSystem.freespaceManager().freeTransactionLogSlot(this.file(idSystem).toBlockedLength(slot));
    }

    public void applySlotChanges(IdSystem idSystem, Slot reservedSlot) {
        int slotChangeCount = this.countSlotChanges(idSystem);
        if (slotChangeCount > 0) {
            Slot transactionLogSlot = this.slotLongEnoughForLog(idSystem, reservedSlot) ? reservedSlot : this.allocateSlot(idSystem, true);
            StatefulBuffer buffer = new StatefulBuffer((Transaction)idSystem.systemTransaction(), transactionLogSlot);
            buffer.writeInt(transactionLogSlot.length());
            buffer.writeInt(slotChangeCount);
            this.appendSlotChanges(idSystem, buffer);
            buffer.write();
            this.flushDatabaseFile(idSystem);
            this.file(idSystem).writeTransactionPointer(transactionLogSlot.address());
            this.flushDatabaseFile(idSystem);
            if (idSystem.writeSlots()) {
                this.flushDatabaseFile(idSystem);
            }
            this.file(idSystem).writeTransactionPointer(0);
            this.flushDatabaseFile(idSystem);
            if (transactionLogSlot != reservedSlot) {
                this.freeSlot(idSystem, transactionLogSlot);
            }
        }
        this.freeSlot(idSystem, reservedSlot);
    }

    private boolean slotLongEnoughForLog(IdSystem idSystem, Slot slot) {
        return slot != null && slot.length() >= this.transactionLogSlotLength(idSystem);
    }

    public void close() {
    }
}

