/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.ObjectHeaderAttributes;
import com.db4o.internal.marshall.SlotFormat;

public final class ObjectHeader {
    private final ClassMetadata _classMetadata;
    public final MarshallerFamily _marshallerFamily;
    public final ObjectHeaderAttributes _headerAttributes;
    private int _handlerVersion;

    public ObjectHeader(ObjectContainerBase container, ReadWriteBuffer reader) {
        this(container, null, reader);
    }

    public ObjectHeader(ClassMetadata classMetadata, ReadWriteBuffer reader) {
        this(null, classMetadata, reader);
    }

    public ObjectHeader(ObjectContainerBase stream, ClassMetadata classMetadata, ReadWriteBuffer reader) {
        int classID = reader.readInt();
        this._marshallerFamily = this.readMarshallerFamily(reader, classID);
        classID = this.normalizeID(classID);
        this._classMetadata = classMetadata != null ? classMetadata : stream.classMetadataForID(classID);
        this._headerAttributes = this.slotFormat().readHeaderAttributes((ByteArrayBuffer)reader);
    }

    public static ObjectHeader defrag(DefragmentContextImpl context) {
        ByteArrayBuffer source = context.sourceBuffer();
        ByteArrayBuffer target = context.targetBuffer();
        ObjectHeader header = new ObjectHeader(context.services().systemTrans().container(), null, source);
        int newID = context.mapping().mappedID(header.classMetadata().getID());
        SlotFormat slotFormat = header.slotFormat();
        slotFormat.writeObjectClassID(target, newID);
        slotFormat.skipMarshallerInfo(target);
        slotFormat.readHeaderAttributes(target);
        return header;
    }

    private SlotFormat slotFormat() {
        return SlotFormat.forHandlerVersion(this.handlerVersion());
    }

    private MarshallerFamily readMarshallerFamily(ReadWriteBuffer reader, int classID) {
        boolean marshallerAware = this.marshallerAware(classID);
        this._handlerVersion = 0;
        if (marshallerAware) {
            this._handlerVersion = reader.readByte();
        }
        MarshallerFamily marshallerFamily = MarshallerFamily.version(this._handlerVersion);
        return marshallerFamily;
    }

    private boolean marshallerAware(int id) {
        return id < 0;
    }

    private int normalizeID(int id) {
        return id < 0 ? -id : id;
    }

    public ClassMetadata classMetadata() {
        return this._classMetadata;
    }

    public int handlerVersion() {
        return this._handlerVersion;
    }

    public static ObjectHeader scrollBufferToContent(LocalObjectContainer container, ByteArrayBuffer buffer) {
        return new ObjectHeader(container, (ReadWriteBuffer)buffer);
    }
}

