/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.references;

import com.db4o.foundation.Visitor4;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.references.HashcodeReferenceSystem;
import com.db4o.internal.references.ReferenceSystem;

public abstract class TransactionalReferenceSystemBase {
    protected final ReferenceSystem _committedReferences;
    protected ReferenceSystem _newReferences;

    public TransactionalReferenceSystemBase() {
        this.createNewReferences();
        this._committedReferences = this.newReferenceSystem();
    }

    private ReferenceSystem newReferenceSystem() {
        return new HashcodeReferenceSystem();
    }

    public abstract void addExistingReference(ObjectReference var1);

    public abstract void addNewReference(ObjectReference var1);

    public abstract void commit();

    protected void traverseNewReferences(Visitor4 visitor) {
        this._newReferences.traverseReferences(visitor);
    }

    protected void createNewReferences() {
        this._newReferences = this.newReferenceSystem();
    }

    public ObjectReference referenceForId(int id) {
        ObjectReference ref = this._newReferences.referenceForId(id);
        if (ref != null) {
            return ref;
        }
        return this._committedReferences.referenceForId(id);
    }

    public ObjectReference referenceForObject(Object obj) {
        ObjectReference ref = this._newReferences.referenceForObject(obj);
        if (ref != null) {
            return ref;
        }
        return this._committedReferences.referenceForObject(obj);
    }

    public abstract void removeReference(ObjectReference var1);

    public abstract void rollback();

    public void traverseReferences(Visitor4 visitor) {
        this.traverseNewReferences(visitor);
        this._committedReferences.traverseReferences(visitor);
    }
}

