/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.reflect.generic;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.Listener4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.generic.KnownClassesRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownClassesCollector {
    private final ObjectContainerBase _container;
    private final KnownClassesRepository _repository;

    public KnownClassesCollector(ObjectContainerBase container, KnownClassesRepository repository) {
        this._container = container;
        this._repository = repository;
    }

    public ReflectClass[] collect() {
        Collection4 classes = new Collection4();
        this.collectKnownClasses(classes);
        return (ReflectClass[])classes.toArray(new ReflectClass[classes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectKnownClasses(Collection4 classes) {
        Listener4<ReflectClass> collectingListener = this.newCollectingClassListener(classes);
        this._repository.addListener(collectingListener);
        try {
            this.collectKnownClasses(classes, Iterators.copy(this._repository.classes()));
        }
        finally {
            this._repository.removeListener(collectingListener);
        }
    }

    private Listener4<ReflectClass> newCollectingClassListener(final Collection4 classes) {
        return new Listener4<ReflectClass>(){

            @Override
            public void onEvent(ReflectClass addedClass) {
                KnownClassesCollector.this.collectKnownClass(classes, addedClass);
            }
        };
    }

    private void collectKnownClasses(Collection4 collector, Iterator4 knownClasses) {
        while (knownClasses.moveNext()) {
            ReflectClass clazz = (ReflectClass)knownClasses.current();
            this.collectKnownClass(collector, clazz);
        }
    }

    private void collectKnownClass(Collection4 classes, ReflectClass clazz) {
        if (this.isInternalClass(clazz)) {
            return;
        }
        if (this.isPrimitiveType(clazz)) {
            return;
        }
        if (clazz.isArray()) {
            return;
        }
        classes.add(clazz);
    }

    private boolean isInternalClass(ReflectClass clazz) {
        return this._container._handlers.ICLASS_INTERNAL.isAssignableFrom(clazz);
    }

    private boolean isPrimitiveType(ReflectClass clazz) {
        ClassMetadata clazzMeta = this._container.classMetadataForReflectClass(clazz);
        return clazzMeta != null && clazzMeta.isPrimitive();
    }
}

