/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.DTrace;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.EmergencyShutdownReadOnlyException;
import com.db4o.foundation.Environments;
import com.db4o.io.Bin;
import com.db4o.io.BinDecorator;
import com.db4o.io.BlockSize;

public class BlockAwareBin
extends BinDecorator {
    private static final int COPY_SIZE = 4096;
    private boolean _readOnly;
    private final BlockSize _blockSize = Environments.my(BlockSize.class);

    public BlockAwareBin(Bin bin) {
        super(bin);
    }

    protected final long regularAddress(int blockAddress, int blockAddressOffset) {
        if (0 == this.blockSize()) {
            throw new IllegalStateException();
        }
        return (long)blockAddress * (long)this.blockSize() + (long)blockAddressOffset;
    }

    public void blockCopy(int oldAddress, int oldAddressOffset, int newAddress, int newAddressOffset, int length) throws Db4oIOException {
        this.copy(this.regularAddress(oldAddress, oldAddressOffset), this.regularAddress(newAddress, newAddressOffset), length);
    }

    public void copy(long oldAddress, long newAddress, int length) throws Db4oIOException {
        if (DTrace.enabled) {
            DTrace.IO_COPY.logLength(newAddress, length);
        }
        if (length > 4096) {
            byte[] buffer = new byte[4096];
            int pos = 0;
            while (pos + 4096 < length) {
                this.copy(buffer, oldAddress + (long)pos, newAddress + (long)pos);
                pos += 4096;
            }
            oldAddress += (long)pos;
            newAddress += (long)pos;
            length -= pos;
        }
        this.copy(new byte[length], oldAddress, newAddress);
    }

    private void copy(byte[] buffer, long oldAddress, long newAddress) throws Db4oIOException {
        this.read(oldAddress, buffer);
        this.write(oldAddress, buffer);
    }

    public int blockRead(int address, int offset, byte[] buffer) throws Db4oIOException {
        return this.blockRead(address, offset, buffer, buffer.length);
    }

    public int blockRead(int address, int offset, byte[] bytes, int length) throws Db4oIOException {
        return this.read(this.regularAddress(address, offset), bytes, length);
    }

    public int blockRead(int address, byte[] buffer) throws Db4oIOException {
        return this.blockRead(address, 0, buffer, buffer.length);
    }

    public int blockRead(int address, byte[] bytes, int length) throws Db4oIOException {
        return this.blockRead(address, 0, bytes, length);
    }

    public int read(long pos, byte[] buffer) throws Db4oIOException {
        return this.read(pos, buffer, buffer.length);
    }

    public void blockWrite(int address, int offset, byte[] buffer) throws Db4oIOException {
        this.blockWrite(address, offset, buffer, buffer.length);
    }

    public void blockWrite(int address, int offset, byte[] bytes, int length) throws Db4oIOException {
        this.write(this.regularAddress(address, offset), bytes, length);
    }

    public void blockWrite(int address, byte[] buffer) throws Db4oIOException {
        this.blockWrite(address, 0, buffer, buffer.length);
    }

    public void blockWrite(int address, byte[] bytes, int length) throws Db4oIOException {
        this.blockWrite(address, 0, bytes, length);
    }

    public void sync() {
        this.validateReadOnly();
        try {
            super.sync();
        }
        catch (Db4oIOException e) {
            this._readOnly = true;
            throw e;
        }
    }

    public void write(long pos, byte[] bytes) throws Db4oIOException {
        this.validateReadOnly();
        try {
            this.write(pos, bytes, bytes.length);
        }
        catch (Db4oIOException e) {
            this._readOnly = true;
            throw e;
        }
    }

    private void validateReadOnly() {
        if (this._readOnly) {
            throw new EmergencyShutdownReadOnlyException();
        }
    }

    public int blockSize() {
        return this._blockSize.value();
    }

    public void blockSize(int blockSize) {
        if (blockSize < 1) {
            throw new IllegalArgumentException();
        }
        this._blockSize.set(blockSize);
    }
}

