/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.ext.Db4oIOException;
import com.db4o.io.Bin;
import com.db4o.io.GrowthStrategy;

public class MemoryBin
implements Bin {
    private byte[] _bytes;
    private int _length;
    private GrowthStrategy _growthStrategy;

    public MemoryBin(int initialSize, GrowthStrategy growthStrategy) {
        this(new byte[initialSize], growthStrategy);
    }

    public MemoryBin(byte[] bytes, GrowthStrategy growthStrategy) {
        this._bytes = bytes;
        this._length = bytes.length;
        this._growthStrategy = growthStrategy;
    }

    public long length() {
        return this._length;
    }

    public long bufferSize() {
        return this._bytes.length;
    }

    public int read(long pos, byte[] bytes, int length) throws Db4oIOException {
        long avail = (long)this._length - pos;
        if (avail <= 0L) {
            return -1;
        }
        int read = Math.min((int)avail, length);
        System.arraycopy(this._bytes, (int)pos, bytes, 0, read);
        return read;
    }

    public void sync() throws Db4oIOException {
    }

    public int syncRead(long position, byte[] bytes, int bytesToRead) {
        return this.read(position, bytes, bytesToRead);
    }

    public void close() {
    }

    public byte[] data() {
        byte[] data = new byte[this._length];
        System.arraycopy(this._bytes, 0, data, 0, this._length);
        return data;
    }

    public void write(long pos, byte[] buffer, int length) throws Db4oIOException {
        if (pos + (long)length > (long)this._bytes.length) {
            long newSize = this._growthStrategy.newSize(this._bytes.length, pos + (long)length);
            byte[] temp = new byte[(int)newSize];
            System.arraycopy(this._bytes, 0, temp, 0, this._length);
            this._bytes = temp;
        }
        System.arraycopy(buffer, 0, this._bytes, (int)pos, length);
        if ((pos += (long)length) > (long)this._length) {
            this._length = (int)pos;
        }
    }
}

