/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataconnector.protocol;

import com.google.common.base.Preconditions;
import com.google.dataconnector.protocol.Dispatchable;
import com.google.dataconnector.protocol.FramingException;
import com.google.dataconnector.protocol.proto.SdcFrame;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class FrameReceiver {
    private static final Logger LOG = Logger.getLogger(FrameReceiver.class);
    static final byte FRAME_START = 42;
    static final byte[] MAGIC = "beefcake".getBytes();
    static final int SEQUENCE_LEN = 8;
    static final int PAYLOAD_LEN = 4;
    static final int HEADER_SIZE = 1 + MAGIC.length + 8 + 4;
    static final int MAX_FRAME_SIZE = 0x100000;
    private boolean dispatching;
    private long sequence = 0L;
    private ConcurrentMap<SdcFrame.FrameInfo.Type, Dispatchable> dispatchMap = new ConcurrentHashMap<SdcFrame.FrameInfo.Type, Dispatchable>();
    private DataInputStream dataInputStream;
    private InputStream inputStream;
    private AtomicLong byteCounter = new AtomicLong();

    public void startDispatching() throws FramingException {
        this.dispatching = true;
        while (true) {
            this.dispatch(this.readFrame());
        }
    }

    public SdcFrame.FrameInfo readOneFrame() throws FramingException {
        Preconditions.checkArgument((!this.dispatching ? 1 : 0) != 0, (Object)"Cannot call readOneFrame.  Dispatching already started.");
        return this.readFrame();
    }

    private SdcFrame.FrameInfo readFrame() throws FramingException {
        Preconditions.checkNotNull((Object)this.inputStream, (Object)"Must specify inputStream before calling readFrame.");
        try {
            int startIndicator = this.inputStream.read();
            LOG.debug((Object)("Start byte: " + startIndicator));
            if ((byte)startIndicator != 42) {
                throw new FramingException("Unexpected frame start read");
            }
            byte[] magic = new byte[MAGIC.length];
            this.readBytes(magic, MAGIC.length);
            String magicString = new String(magic);
            LOG.debug((Object)("Magic: " + magicString));
            if (!new String(magic).equals(new String(MAGIC))) {
                throw new FramingException("Unexpected frame magic read");
            }
            Arrays.equals(magic, MAGIC);
            long readSequence = this.dataInputStream.readLong();
            LOG.debug((Object)("sequence: " + readSequence));
            if (readSequence == this.sequence) {
                ++this.sequence;
            } else {
                throw new FramingException("Unexpected sequence number. Expected: " + this.sequence + " got:" + readSequence);
            }
            int payloadLength = this.dataInputStream.readInt();
            LOG.debug((Object)("payload length: " + payloadLength));
            if (payloadLength < 0 || payloadLength > 0x100000) {
                throw new FramingException("Payload length invalid.");
            }
            byte[] payload = new byte[payloadLength];
            int bytesRead = 0;
            while ((bytesRead += this.inputStream.read(payload, bytesRead, payloadLength - bytesRead)) < payloadLength) {
            }
            if (this.byteCounter != null) {
                this.byteCounter.addAndGet(HEADER_SIZE + payloadLength);
            }
            LOG.debug((Object)("payload: " + payload));
            try {
                SdcFrame.FrameInfo frameInfo = SdcFrame.FrameInfo.parseFrom(payload);
                LOG.debug((Object)("frame:\n" + frameInfo.toString()));
                LOG.debug((Object)("frame type recevd: " + (Object)((Object)frameInfo.getType())));
                return frameInfo;
            }
            catch (InvalidProtocolBufferException e) {
                throw new FramingException(e);
            }
        }
        catch (IOException e) {
            throw new FramingException("IO Exception on tunnelsocket", e);
        }
    }

    private void readBytes(byte[] buffer, int amountToRead) throws IOException {
        int bytesRead = 0;
        while ((bytesRead += this.inputStream.read(buffer, bytesRead, amountToRead - bytesRead)) < amountToRead) {
        }
    }

    void dispatch(SdcFrame.FrameInfo frameInfo) throws FramingException {
        if (this.dispatchMap.containsKey((Object)frameInfo.getType())) {
            ((Dispatchable)this.dispatchMap.get((Object)frameInfo.getType())).dispatch(frameInfo);
        } else {
            LOG.info((Object)("Unknown frame received: " + (Object)((Object)frameInfo)));
        }
    }

    public void registerDispatcher(SdcFrame.FrameInfo.Type type, Dispatchable dispatchable) {
        this.dispatchMap.put(type, dispatchable);
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.dataInputStream = new DataInputStream(inputStream);
    }

    public void setByteCounter(AtomicLong byteCounter) {
        this.byteCounter = byteCounter;
    }
}

