/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataconnector.protocol;

import com.google.common.base.Preconditions;
import com.google.dataconnector.protocol.FrameReceiver;
import com.google.dataconnector.protocol.proto.SdcFrame;
import com.google.dataconnector.util.ShutdownManager;
import com.google.dataconnector.util.Stoppable;
import com.google.inject.Inject;
import com.google.protobuf.ByteString;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameSender
extends Thread
implements Stoppable {
    private static final Logger LOG = Logger.getLogger(FrameSender.class);
    private final BlockingQueue<SdcFrame.FrameInfo> sendQueue;
    private ShutdownManager shutdownManager;
    private OutputStream outputStream;
    private AtomicLong byteCounter;
    private DataOutputStream dataOutputStream;
    private long sequence = 0L;

    @Inject
    public FrameSender(BlockingQueue<SdcFrame.FrameInfo> sendQueue, ShutdownManager shutdownManager) {
        this.sendQueue = sendQueue;
        this.shutdownManager = shutdownManager;
    }

    public void sendFrame(SdcFrame.FrameInfo.Type type, ByteString payload) {
        this.sendFrame(SdcFrame.FrameInfo.newBuilder().setType(type).setPayload(payload).build());
    }

    public void sendFrame(SdcFrame.FrameInfo frame) {
        if (!frame.hasType()) {
            throw new RuntimeException("Frame missing type info");
        }
        try {
            this.sendQueue.put(frame);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    void writeOneFrame(SdcFrame.FrameInfo frameInfo) throws IOException {
        Preconditions.checkNotNull((Object)this.outputStream, (Object)"Must specify outputStream before writing frames.");
        byte[] frameInfoBytes = frameInfo.toByteArray();
        this.outputStream.write(42);
        LOG.debug((Object)"Start byte: 42");
        this.outputStream.write(FrameReceiver.MAGIC);
        LOG.debug((Object)("Magic: " + FrameReceiver.MAGIC));
        this.dataOutputStream.writeLong(this.sequence);
        LOG.debug((Object)("sequence: " + this.sequence));
        this.dataOutputStream.writeInt(frameInfoBytes.length);
        LOG.debug((Object)("payload length: " + frameInfoBytes.length));
        this.outputStream.write(frameInfoBytes);
        LOG.debug((Object)("payload: " + frameInfoBytes));
        LOG.debug((Object)("frame:\n" + frameInfo.toString()));
        LOG.debug((Object)("sending frame type: " + (Object)((Object)frameInfo.getType())));
        if (this.byteCounter != null) {
            this.byteCounter.addAndGet(FrameReceiver.HEADER_SIZE + frameInfoBytes.length);
        }
        ++this.sequence;
    }

    @Override
    public void run() {
        this.shutdownManager.addStoppable(this);
        this.setName(this.getClass().getName());
        try {
            while (true) {
                SdcFrame.FrameInfo frameInfo = SdcFrame.FrameInfo.newBuilder(this.sendQueue.take()).setSequence(this.sequence).build();
                this.writeOneFrame(frameInfo);
            }
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Sending frames shutting down", (Throwable)e);
        }
        catch (IOException e) {
            LOG.info((Object)"IO error while sending frame", (Throwable)e);
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        this.dataOutputStream = new DataOutputStream(outputStream);
    }

    public void setByteCounter(AtomicLong byteCounter) {
        this.byteCounter = byteCounter;
    }

    @Override
    public void shutdown() {
        this.interrupt();
    }
}

