/*
 * Decompiled with CFR 0.152.
 */
package com.google.dataconnector.util;

import com.google.common.collect.Maps;
import com.google.dataconnector.util.Pair;
import com.google.dataconnector.util.Stoppable;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@Singleton
public class ShutdownManager {
    private static final Logger LOG = Logger.getLogger(ShutdownManager.class);
    private static final String DEFAULT = "__default__";
    private Map<String, List<Pair<String, Stoppable>>> stoppableGroups = Maps.newHashMap();

    public void addStoppable(Stoppable stoppable) {
        this.addStoppable(stoppable, DEFAULT);
    }

    public void addStoppable(Stoppable stoppable, String group) {
        if (!this.stoppableGroups.containsKey(group)) {
            this.stoppableGroups.put(group, new ArrayList());
        }
        this.stoppableGroups.get(group).add(new Pair<String, Stoppable>(stoppable.getClass().getName(), stoppable));
        LOG.debug((Object)("Managing shutdown for " + stoppable.getClass().getName()));
    }

    public void shutdownAll() {
        for (String group : this.stoppableGroups.keySet()) {
            this.shutdownGroup(group);
        }
    }

    public void shutdownGroup(String groupName) {
        if (!this.stoppableGroups.containsKey(groupName)) {
            return;
        }
        for (Pair<String, Stoppable> stoppablePair : this.stoppableGroups.get(groupName)) {
            try {
                LOG.info((Object)("Issuing shutdown for " + stoppablePair.first()));
                stoppablePair.second().shutdown();
            }
            catch (RuntimeException e) {
                LOG.warn((Object)("Stop failed for " + stoppablePair.first()), (Throwable)e);
            }
        }
        this.stoppableGroups.remove(groupName);
    }
}

