/*
 * Decompiled with CFR 0.152.
 */
package org.jsslutils.sslcontext.keymanagers;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import org.jsslutils.sslcontext.X509KeyManagerWrapper;

public class FixedServerAliasKeyManager
implements X509KeyManager {
    private final X509KeyManager keyManager;
    private final String alias;

    public FixedServerAliasKeyManager(X509KeyManager keyManager, String alias) {
        this.keyManager = keyManager;
        this.alias = alias;
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        return this.keyManager.chooseClientAlias(keyType, issuers, socket);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.alias;
    }

    public X509Certificate[] getCertificateChain(String alias) {
        return this.keyManager.getCertificateChain(alias);
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getClientAliases(keyType, issuers);
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.keyManager.getPrivateKey(alias);
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getServerAliases(keyType, issuers);
    }

    public static class Wrapper
    implements X509KeyManagerWrapper {
        private final String alias;

        public Wrapper(String alias) {
            this.alias = alias;
        }

        public X509KeyManager wrapKeyManager(X509KeyManager keyManager) {
            return new FixedServerAliasKeyManager(keyManager, this.alias);
        }
    }
}

