/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch04.sec2.sub5;

import java.io.IOException;
import org.restlet.data.Reference;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ServerResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MailServerResource
extends ServerResource {
    @Get
    public Representation toXml() throws IOException {
        DomRepresentation result = new DomRepresentation();
        result.setIndenting(true);
        result.setNamespaceAware(true);
        Document doc = result.getDocument();
        Element mailElt = doc.createElementNS("http://www.rmep.org/namespaces/1.0", "mail");
        doc.appendChild(mailElt);
        Element statusElt = doc.createElement("status");
        statusElt.setTextContent("received");
        mailElt.appendChild(statusElt);
        Element subjectElt = doc.createElement("subject");
        subjectElt.setTextContent("Message to self");
        mailElt.appendChild(subjectElt);
        Element contentElt = doc.createElement("content");
        contentElt.setTextContent("Doh!");
        mailElt.appendChild(contentElt);
        Element accountRefElt = doc.createElement("accountRef");
        accountRefElt.setTextContent(new Reference(this.getReference(), "..").getTargetRef().toString());
        mailElt.appendChild(accountRefElt);
        return result;
    }

    @Put
    public void store(DomRepresentation mailRep) {
        String rmepNs = "http://www.rmep.org/namespaces/1.0";
        mailRep.setNamespaceAware(true);
        mailRep.getNamespaces().put("", rmepNs);
        mailRep.getNamespaces().put("rmep", rmepNs);
        String status = mailRep.getText("/:mail/:status");
        String subject = mailRep.getText("/rmep:mail/:subject");
        String content = mailRep.getText("/rmep:mail/rmep:content");
        String accountRef = mailRep.getText("/:mail/rmep:accountRef");
        System.out.println("Status: " + status);
        System.out.println("Subject: " + subject);
        System.out.println("Content: " + content);
        System.out.println("Account URI: " + accountRef);
    }
}

