/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.oauth.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.restlet.example.ext.oauth.mongo.MongoClient;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.AbstractClientManager;
import org.restlet.ext.oauth.internal.Client;

public class MongoClientManager
extends AbstractClientManager {
    private DBCollection clients;

    public MongoClientManager(DB db) {
        this.clients = db.getCollection("clients");
    }

    protected Client createClient(String clientId, char[] clientSecret, Client.ClientType clientType, String[] redirectURIs, Map<String, Object> properties) {
        BasicDBObject client = new BasicDBObject("_id", (Object)clientId);
        if (clientSecret != null) {
            client.put("client_secret", (Object)String.copyValueOf(clientSecret));
        }
        switch (clientType) {
            case PUBLIC: {
                client.put("client_type", (Object)"public");
                break;
            }
            case CONFIDENTIAL: {
                client.put("client_type", (Object)"confidential");
            }
        }
        if (redirectURIs != null && redirectURIs.length > 0) {
            client.put("redirect_uris", Arrays.asList(redirectURIs));
        }
        Object[] supportedFlows = (Object[])properties.remove("supported_flows");
        ArrayList<String> responseTypes = new ArrayList<String>();
        ArrayList<String> grantTypes = new ArrayList<String>();
        for (Object flow : supportedFlows) {
            if (flow instanceof ResponseType) {
                responseTypes.add(flow.toString());
                continue;
            }
            if (!(flow instanceof GrantType)) continue;
            grantTypes.add(flow.toString());
        }
        client.put("allowed_response_types", responseTypes);
        client.put("allowed_grant_types", grantTypes);
        client.put("properties", properties);
        this.clients.insert(new DBObject[]{client});
        return new MongoClient((DBObject)client);
    }

    public void deleteClient(String id) {
        this.clients.findAndRemove((DBObject)new BasicDBObject("_id", (Object)id));
    }

    public Client findById(String id) {
        DBObject client = this.clients.findOne((DBObject)new BasicDBObject("_id", (Object)id));
        if (client == null) {
            return null;
        }
        return new MongoClient(client);
    }
}

