/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.openid;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.openid4java.message.DirectError;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;
import org.openid4java.server.ServerManager;
import org.restlet.data.Form;
import org.restlet.data.Header;
import org.restlet.data.Method;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ServerResource;
import org.restlet.util.Series;

public class OpenIdProvider
extends ServerResource {
    public OpenIdProvider() {
        this.getLogger().info("OpenID CREATED NEW PROVIDER");
    }

    @Post(value="form")
    public Representation represent(Representation input) {
        Form f = new Form(input);
        return this.handle(new ParameterList(f.getValuesMap()));
    }

    @Get(value="form")
    public Representation represent() {
        return this.handle(new ParameterList(this.getQuery().getValuesMap()));
    }

    private Representation handle(ParameterList request) {
        String responseText;
        String mode;
        Logger log = this.getLogger();
        log.info("Handle on OP");
        ConcurrentMap attribs = this.getContext().getAttributes();
        ServerManager manager = (ServerManager)attribs.get("openid_manager");
        log.info("OP endpoint = " + manager.getOPEndpointUrl());
        String string = mode = request.hasParameter("openid.mode") ? request.getParameterValue("openid.mode") : null;
        if ("associate".equals(mode)) {
            Message response = manager.associationResponse(request);
            responseText = response.keyValueFormEncoding();
        } else {
            if ("checkid_setup".equals(mode) || "checkid_immediate".equals(mode)) {
                Boolean authenticatedAndApproved;
                String userSelectedClaimedId;
                List<Object> userData = this.userInteraction(request, manager.getOPEndpointUrl());
                String userSelectedId = (String)userData.get(0);
                Message response = manager.authResponse(request, userSelectedId, userSelectedClaimedId = (String)userData.get(1), (authenticatedAndApproved = (Boolean)userData.get(2)).booleanValue());
                if (response instanceof DirectError) {
                    Form f = new Form();
                    Map m = response.getParameterMap();
                    for (String key : m.keySet()) {
                        f.add(key, (String)m.get(key));
                    }
                    return f.getWebRepresentation();
                }
                this.redirectSeeOther(response.getDestinationUrl(true));
                return new EmptyRepresentation();
            }
            if ("check_authentication".equals(mode)) {
                Message response = manager.verify(request);
                log.info("OpenID : " + response.keyValueFormEncoding());
                responseText = response.keyValueFormEncoding();
            } else {
                if (Method.GET.equals((Object)this.getMethod())) {
                    this.sendXRDSLocation();
                    return new StringRepresentation((CharSequence)"XRDS Discovery Information");
                }
                DirectError response = DirectError.createDirectError((String)"Unknown request");
                responseText = response.keyValueFormEncoding();
            }
        }
        return new StringRepresentation((CharSequence)responseText);
    }

    private void sendXRDSLocation() {
        ConcurrentMap attribs = this.getContext().getAttributes();
        String id = this.getQuery().getFirstValue("id");
        String xrds = attribs.get("xrds").toString();
        String location = id != null ? xrds + "?id=" + id : xrds;
        this.getLogger().info("XRDS endpoint = " + xrds);
        Series headers = (Series)this.getResponse().getAttributes().get("org.restlet.http.headers");
        if (headers == null) {
            headers = new Series(Header.class);
            headers.add("X-XRDS-Location", location);
            this.getResponse().getAttributes().put("org.restlet.http.headers", headers);
        } else {
            headers.add("X-XRDS-Location", location);
        }
        this.getLogger().info("Sending empty representation.");
    }

    private List<Object> userInteraction(ParameterList request, String endpoint) {
        StringBuilder id = new StringBuilder();
        id.append(endpoint);
        id.append("?id=");
        id.append("foo");
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(0, id.toString());
        result.add(1, id.toString());
        result.add(2, Boolean.TRUE);
        return result;
    }
}

