/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.rest.ch7;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.example.book.rest.ch7.Application;
import org.restlet.example.book.rest.ch7.Bookmark;
import org.restlet.example.book.rest.ch7.User;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public class UserResource
extends ServerResource {
    private String login;
    private boolean modifiable;
    private String password;
    private User user;
    private String userName;
    private List<Variant> variants;

    public void challenge() {
        this.getResponse().setStatus(Status.CLIENT_ERROR_CONFLICT);
        this.getResponse().getChallengeRequests().add(new ChallengeRequest(ChallengeScheme.HTTP_BASIC, "Restlet"));
    }

    public int checkAuthorization() {
        int result = 0;
        if (this.user != null && this.login != null && this.password != null) {
            result = this.userName.equals(this.login) && this.password.equals(this.user.getPassword()) ? 1 : -1;
        }
        return result;
    }

    public Representation delete() throws ResourceException {
        if (this.isModifiable()) {
            switch (this.checkAuthorization()) {
                case 1: {
                    for (Bookmark bookmark : this.user.getBookmarks()) {
                        this.getContainer().delete((Object)bookmark);
                    }
                    this.getContainer().delete((Object)this.user);
                    this.getContainer().commit();
                    this.setStatus(Status.SUCCESS_OK);
                    break;
                }
                case 0: {
                    this.challenge();
                    break;
                }
                case -1: {
                    this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
                }
            }
        } else {
            return super.delete();
        }
        return null;
    }

    public void doInit() {
        this.userName = (String)this.getRequestAttributes().get("username");
        ChallengeResponse cr = this.getChallengeResponse();
        this.login = cr != null ? cr.getIdentifier() : null;
        this.password = cr != null ? new String(cr.getSecret()) : null;
        this.user = this.findUser();
        if (this.user != null) {
            this.variants = new ArrayList<Variant>();
            this.variants.add(new Variant(MediaType.TEXT_PLAIN));
        }
        this.modifiable = true;
    }

    public User findUser() {
        User result = null;
        if (this.userName != null) {
            Predicate<User> predicate = new Predicate<User>(){
                private static final long serialVersionUID = 1L;

                public boolean match(User candidate) {
                    return UserResource.this.userName.equals(candidate.getName());
                }
            };
            ObjectSet users = this.getContainer().query((Predicate)predicate);
            if (users != null && users.size() > 0) {
                result = (User)users.get(0);
            }
        }
        return result;
    }

    public Representation get(Variant variant) throws ResourceException {
        StringRepresentation result = null;
        if (variant != null && variant.getMediaType().equals((Object)MediaType.TEXT_PLAIN)) {
            StringBuilder sb = new StringBuilder();
            sb.append("------------\n");
            sb.append("User details\n");
            sb.append("------------\n\n");
            sb.append("Name:  ").append(this.user.getFullName()).append('\n');
            sb.append("Email: ").append(this.user.getEmail()).append('\n');
            result = new StringRepresentation((CharSequence)sb);
        }
        return result;
    }

    public Application getApplication() {
        return (Application)super.getApplication();
    }

    public ObjectContainer getContainer() {
        return this.getApplication().getContainer();
    }

    public User getUser() {
        return this.user;
    }

    public List<Variant> getVariants() {
        return this.variants;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public Representation put(Representation entity) throws ResourceException {
        if (this.isModifiable()) {
            if (entity.getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM, true)) {
                boolean canSet = true;
                if (this.getUser() == null) {
                    this.setUser(new User());
                    this.getUser().setName(this.userName);
                    this.setStatus(Status.SUCCESS_CREATED);
                } else {
                    switch (this.checkAuthorization()) {
                        case 1: {
                            this.setStatus(Status.SUCCESS_NO_CONTENT);
                            break;
                        }
                        case 0: {
                            this.challenge();
                            canSet = false;
                            break;
                        }
                        case -1: {
                            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
                            canSet = false;
                        }
                    }
                }
                if (canSet) {
                    Form form = new Form(entity);
                    this.getUser().setEmail(form.getFirstValue("user[email]"));
                    this.getUser().setFullName(form.getFirstValue("user[full_name]"));
                    this.getUser().setPassword(form.getFirstValue("user[password]"));
                    this.getContainer().store((Object)this.getUser());
                    this.getContainer().commit();
                }
            }
        } else {
            return super.put(entity);
        }
        return null;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public void setUser(User user) {
        this.user = user;
    }
}

