/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.oauth.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.restlet.example.ext.oauth.mongo.MongoToken;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.OAuthResourceDefs;
import org.restlet.ext.oauth.internal.AbstractTokenManager;
import org.restlet.ext.oauth.internal.AuthSession;
import org.restlet.ext.oauth.internal.Client;
import org.restlet.ext.oauth.internal.Token;

public class MongoTokenManager
extends AbstractTokenManager
implements OAuthResourceDefs {
    private DBCollection tokens;
    private DBCollection sessions;

    public MongoTokenManager(DB db) {
        this.tokens = db.getCollection("tokens");
        this.sessions = db.getCollection("sessions");
    }

    public Token generateToken(Client client, String username, String[] scope) throws OAuthException {
        DBObject token = this.tokens.findOne(this.createQuery(client, username));
        if (token == null) {
            token = new BasicDBObject();
            token.put("client_id", (Object)client.getClientId());
            if (username != null) {
                token.put("username", (Object)username);
            }
        }
        token.put("scope", Arrays.asList(scope));
        token.put("expires_in", (Object)this.getExpirePeriod());
        token.put("token_type", (Object)"Bearer");
        token.put("access_token", (Object)this.generateRawToken());
        token.put("refresh_token", (Object)this.generateRawToken());
        token.put("timestamp", (Object)((int)(System.currentTimeMillis() / 1000L)));
        this.tokens.ensureIndex((DBObject)new BasicDBObject("access_token", (Object)"1"), (DBObject)new BasicDBObject("unique", (Object)true));
        this.tokens.ensureIndex((DBObject)new BasicDBObject("refresh_token", (Object)"1"), (DBObject)new BasicDBObject("unique", (Object)true));
        this.tokens.save(token);
        return new MongoToken(token);
    }

    public Token refreshToken(Client client, String refreshToken, String[] scope) throws OAuthException {
        DBObject token = this.tokens.findOne((DBObject)new BasicDBObject("refresh_token", (Object)refreshToken));
        if (token == null) {
            throw new OAuthException(OAuthError.invalid_grant, "Invalid refresh token.", null);
        }
        if (!token.get("client_id").equals(client.getClientId())) {
            throw new OAuthException(OAuthError.invalid_grant, "The refresh token was not issued to the client.", null);
        }
        if (scope != null && scope.length != 0) {
            List<String> newScopeList = Arrays.asList(scope);
            if (!((List)token.get("scope")).containsAll(newScopeList)) {
                throw new OAuthException(OAuthError.invalid_scope, "The requested scope is exceeds the scope granted by the resource owner.", null);
            }
            token.put("scope", newScopeList);
        }
        token.put("access_token", (Object)this.generateRawToken());
        if (this.isUpdateRefreshToken()) {
            token.put("refresh_token", (Object)this.generateRawToken());
        }
        this.tokens.ensureIndex((DBObject)new BasicDBObject("access_token", (Object)"1"), (DBObject)new BasicDBObject("unique", (Object)true));
        this.tokens.ensureIndex((DBObject)new BasicDBObject("refresh_token", (Object)"1"), (DBObject)new BasicDBObject("unique", (Object)true));
        this.tokens.save(token);
        return new MongoToken(token);
    }

    private DBObject createQuery(Client client, String username) {
        BasicDBObject query = new BasicDBObject("client_id", (Object)client.getClientId());
        if (username != null) {
            query.append("username", (Object)username);
        } else {
            query.append("username", (Object)new BasicDBObject("$exists", (Object)false));
        }
        return query;
    }

    public String storeSession(AuthSession session) throws OAuthException {
        BasicDBObject sessionObj = new BasicDBObject();
        Map map = session.toMap();
        for (String key : map.keySet()) {
            sessionObj.put(key, map.get(key));
        }
        String code = this.generateRawCode();
        sessionObj.put("_id", (Object)code);
        this.sessions.insert(new DBObject[]{sessionObj});
        return code;
    }

    public AuthSession restoreSession(String code) throws OAuthException {
        DBObject sessionObj = this.sessions.findOne((DBObject)new BasicDBObject("_id", (Object)code));
        if (sessionObj == null) {
            throw new OAuthException(OAuthError.invalid_grant, "Invalid code.", null);
        }
        return AuthSession.toAuthSession((Map)sessionObj.toMap());
    }

    public Token validateToken(String accessToken) throws OAuthException {
        DBObject token = this.tokens.findOne((DBObject)new BasicDBObject("access_token", (Object)accessToken));
        if (token == null) {
            throw new OAuthException(OAuthError.invalid_token, "The access token revoked.", null);
        }
        MongoToken tokenImpl = new MongoToken(token);
        if (tokenImpl.isExpired()) {
            throw new OAuthException(OAuthError.invalid_token, "The access token expired.", null);
        }
        return tokenImpl;
    }

    public Token findToken(Client client, String username) {
        DBObject token = this.tokens.findOne(this.createQuery(client, username));
        if (token == null) {
            return null;
        }
        return new MongoToken(token);
    }

    public Token[] findTokens(String username) {
        DBCursor cursor = this.tokens.find((DBObject)new BasicDBObject("username", (Object)username));
        ArrayList<MongoToken> list = new ArrayList<MongoToken>();
        while (cursor.hasNext()) {
            DBObject token = cursor.next();
            list.add(new MongoToken(token));
        }
        return list.toArray(new Token[list.size()]);
    }

    public Token[] findTokens(Client client) {
        DBCursor cursor = this.tokens.find((DBObject)new BasicDBObject("client_id", (Object)client.getClientId()));
        ArrayList<MongoToken> list = new ArrayList<MongoToken>();
        while (cursor.hasNext()) {
            DBObject token = cursor.next();
            list.add(new MongoToken(token));
        }
        return list.toArray(new Token[list.size()]);
    }

    public void revokeToken(Client client, String username) {
        this.tokens.remove(this.createQuery(client, username));
    }

    public void revokeAllTokens(String username) {
        this.tokens.remove((DBObject)new BasicDBObject("username", (Object)username));
    }

    public void revokeAllTokens(Client client) {
        this.tokens.remove((DBObject)new BasicDBObject("client_id", (Object)client.getClientId()));
    }
}

