/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.sip;

import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.Protocol;
import org.restlet.example.ext.sip.UacResource;
import org.restlet.ext.sip.Address;
import org.restlet.ext.sip.SipClientResource;

public class UacClientResource
implements UacResource {
    private SipClientResource clientResource;
    private UacResource proxy;

    public static void main(String[] args) {
        UacClientResource cr = new UacClientResource("sip:bob@locahost");
        cr.start();
        UacClientResource.sleep();
        cr.acknowledge();
        UacClientResource.sleep();
        cr.stop();
    }

    public UacClientResource(String uri) {
        this.clientResource = new SipClientResource(uri);
        this.clientResource.setCallId("a84b4c76e66710@pc33.atlanta.com");
        this.clientResource.setCommandSequence("314159");
        this.clientResource.setFrom(new Address("sip:alice@atlanta.com", "Alice"));
        this.clientResource.setTo(new Address("sip:bob@biloxi.com", "Bob"));
        Client client = new Client(new Context(), Protocol.SIP);
        client.getContext().getParameters().add("minThreads", "1");
        client.getContext().getParameters().add("tracing", "true");
        client.getContext().getParameters().add("proxyHost", "localhost");
        client.getContext().getParameters().add("proxyPort", "5060");
        this.clientResource.setNext((Uniform)client);
        this.proxy = (UacResource)this.clientResource.wrap(UacResource.class);
    }

    @Override
    public void acknowledge() {
        this.proxy.acknowledge();
        System.out.println("acknowledge\n");
        try {
            if (this.clientResource.getResponseEntity() != null) {
                this.clientResource.getResponseEntity().exhaust();
            }
        }
        catch (Exception e) {
            System.out.println("acknowledge " + e.getMessage());
        }
    }

    private static void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start() {
        this.proxy.start();
        System.out.println("start\n");
        try {
            if (this.clientResource.getResponseEntity() != null) {
                this.clientResource.getResponseEntity().exhaust();
            }
        }
        catch (Exception e) {
            System.out.println("start " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        this.proxy.stop();
        System.out.println("stop\n");
        try {
            if (this.clientResource.getResponseEntity() != null) {
                this.clientResource.getResponseEntity().exhaust();
            }
        }
        catch (Exception e) {
            System.out.println("stop " + e.getMessage());
            e.printStackTrace();
        }
    }
}

