/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.rdf.foaf;

import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.example.ext.rdf.foaf.data.ListFacade;
import org.restlet.example.ext.rdf.foaf.objects.ObjectsFacade;
import org.restlet.example.ext.rdf.foaf.resources.ContactResource;
import org.restlet.example.ext.rdf.foaf.resources.ContactsResource;
import org.restlet.example.ext.rdf.foaf.resources.UserResource;
import org.restlet.example.ext.rdf.foaf.resources.UsersResource;
import org.restlet.resource.ClientResource;
import org.restlet.resource.Directory;
import org.restlet.routing.Redirector;
import org.restlet.routing.Router;

public class Application
extends org.restlet.Application {
    private final ObjectsFacade dataFacade;
    private Configuration fmc;
    private final String webRootPath;

    public static Properties getProperties(String propertiesUri) throws IOException {
        ClientResource resource = new ClientResource(propertiesUri);
        try {
            resource.get();
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot access to the configuration file: \"");
            stringBuilder.append(propertiesUri);
            stringBuilder.append("\"");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        Properties properties = new Properties();
        properties.load(resource.getResponseEntity().getStream());
        return properties;
    }

    public static void main(String ... args) throws Exception {
        Component component = new Component();
        component.getServers().add(Protocol.HTTP, 8585);
        component.getClients().add(Protocol.FILE);
        component.getClients().add(Protocol.CLAP);
        component.getClients().add(Protocol.HTTP);
        component.getDefaultHost().attach("/foaf", (Restlet)new Application());
        component.start();
    }

    public Application() throws IOException {
        this.getConnectorService().getClientProtocols().add(Protocol.FILE);
        this.getConnectorService().getClientProtocols().add(Protocol.CLAP);
        this.getConnectorService().getClientProtocols().add(Protocol.HTTP);
        Properties properties = Application.getProperties("clap://class/config/foafApplication.properties");
        this.webRootPath = properties.getProperty("web.root.path");
        this.dataFacade = new ObjectsFacade(new ListFacade());
        try {
            File templateDir = new File(this.webRootPath + "/tmpl");
            this.fmc = new Configuration();
            this.fmc.setDirectoryForTemplateLoading(templateDir);
        }
        catch (Exception e) {
            this.getLogger().severe("Unable to configure FreeMarker.");
            e.printStackTrace();
        }
        this.getMetadataService().addExtension("rdf", (Metadata)MediaType.APPLICATION_RDF_XML, true);
        this.getTunnelService().setExtensionsTunnel(true);
    }

    public Restlet createInboundRoot() {
        Router router = new Router(this.getContext());
        router.attachDefault((Restlet)new Redirector(this.getContext(), "/users", 1));
        Directory imgDirectory = new Directory(this.getContext(), (Reference)LocalReference.createFileReference((String)(this.webRootPath + "/images")));
        router.attach("/images", (Restlet)imgDirectory);
        Directory cssDirectory = new Directory(this.getContext(), (Reference)LocalReference.createFileReference((String)(this.webRootPath + "/stylesheets")));
        router.attach("/stylesheets", (Restlet)cssDirectory);
        router.attach("/users", UsersResource.class);
        router.attach("/users/{userId}", UserResource.class);
        router.attach("/users/{userId}/contacts", ContactsResource.class);
        router.attach("/users/{userId}/contacts/{contactId}", ContactResource.class);
        return router;
    }

    public Configuration getFmc() {
        return this.fmc;
    }

    public ObjectsFacade getObjectsFacade() {
        return this.dataFacade;
    }
}

