/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.sip;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.example.ext.sip.UacResource;
import org.restlet.ext.sip.SipResponse;
import org.restlet.ext.sip.SipServerResource;
import org.restlet.ext.sip.SipStatus;

@Deprecated
public class UacServerResource
extends SipServerResource
implements UacResource {
    private static long SLEEP_TIME;
    private static boolean TRACE;
    private static AtomicLong TAG;

    public static void main(String[] args) throws Exception {
        Server server = null;
        server = args.length == 1 ? new Server(new Context(), Protocol.SIP, Integer.parseInt(args[0]), UacServerResource.class) : new Server(new Context(), Protocol.SIP, UacServerResource.class);
        ClassLoader cl = UacServerResource.class.getClassLoader();
        InputStream is = cl.getResourceAsStream("UacServerResource.properties");
        if (is == null) {
            is = cl.getResourceAsStream("org/restlet/example/ext/sip/UacServerResource.properties");
        }
        if (is != null) {
            Properties p = new Properties();
            p.load(is);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                server.getContext().getParameters().add((String)entry.getKey(), (String)entry.getValue());
            }
            String str = p.getProperty("sleepTime", "100");
            try {
                SLEEP_TIME = Integer.parseInt(str);
            }
            catch (Throwable e) {
                // empty catch block
            }
            str = p.getProperty("trace", "false");
            try {
                TRACE = Boolean.parseBoolean(str);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        server.start();
    }

    @Override
    public void acknowledge() {
        this.trace();
    }

    private void sleep() {
        try {
            Thread.sleep(SLEEP_TIME);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void start() {
        this.trace();
        SipResponse provisionalResponse = new SipResponse((Request)this.getRequest());
        provisionalResponse.setStatus(SipStatus.INFO_TRYING);
        provisionalResponse.commit();
        this.sleep();
        provisionalResponse = new SipResponse((Request)this.getRequest());
        provisionalResponse.setStatus(SipStatus.INFO_RINGING);
        provisionalResponse.commit();
        this.sleep();
        provisionalResponse = new SipResponse((Request)this.getRequest());
        provisionalResponse.setStatus(SipStatus.INFO_SESSION_PROGRESS);
        provisionalResponse.commit();
        this.sleep();
        if (this.getTo() != null) {
            this.getTo().getParameters().add("tag", "restlet" + TAG.incrementAndGet());
        }
        provisionalResponse = new SipResponse((Request)this.getRequest());
        provisionalResponse.setStatus(SipStatus.SUCCESS_OK);
        provisionalResponse.commit();
        this.sleep();
        this.setStatus(SipStatus.SUCCESS_OK);
    }

    @Override
    public void stop() {
        this.trace();
        this.setStatus(SipStatus.SUCCESS_OK);
    }

    private void trace() {
        if (TRACE) {
            System.out.println("--------------start trace--------------------");
            System.out.println("Method: " + this.getMethod());
            System.out.println("Call ID: " + this.getCallId());
            System.out.println("Call Sequence: " + this.getCommandSequence());
            System.out.println("To: " + this.getTo());
            System.out.println("From: " + this.getFrom());
            System.out.println("Max Forwards: " + this.getMaxForwards());
            System.out.println("---------------------------------------------");
        }
    }

    static {
        TAG = new AtomicLong(1000L);
    }
}

