/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.oauth.server;

import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.ChallengeScheme;
import org.restlet.example.ext.oauth.server.LoginPageServerResource;
import org.restlet.example.ext.oauth.server.OAuth2Sample;
import org.restlet.ext.oauth.AccessTokenServerResource;
import org.restlet.ext.oauth.AuthPageServerResource;
import org.restlet.ext.oauth.AuthorizationServerResource;
import org.restlet.ext.oauth.ClientVerifier;
import org.restlet.ext.oauth.HttpOAuthHelper;
import org.restlet.ext.oauth.TokenAuthServerResource;
import org.restlet.ext.oauth.internal.ClientManager;
import org.restlet.ext.oauth.internal.TokenManager;
import org.restlet.resource.Directory;
import org.restlet.routing.Router;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.Verifier;

public class OAuth2ServerApplication
extends Application {
    public synchronized Restlet createInboundRoot() {
        Router router = new Router(this.getContext());
        this.getContext().getAttributes().put(ClientManager.class.getName(), OAuth2Sample.getClientManager());
        this.getContext().getAttributes().put(TokenManager.class.getName(), OAuth2Sample.getTokenManager());
        router.attach("/authorize", AuthorizationServerResource.class);
        router.attach(HttpOAuthHelper.getAuthPage((Context)this.getContext()), AuthPageServerResource.class);
        HttpOAuthHelper.setAuthPageTemplate((String)"authorize.html", (Context)this.getContext());
        HttpOAuthHelper.setAuthSkipApproved((boolean)true, (Context)this.getContext());
        HttpOAuthHelper.setErrorPageTemplate((String)"error.html", (Context)this.getContext());
        router.attach(HttpOAuthHelper.getLoginPage((Context)this.getContext()), LoginPageServerResource.class);
        ChallengeAuthenticator clientAuthenticator = new ChallengeAuthenticator(this.getContext(), ChallengeScheme.HTTP_BASIC, "OAuth2Sample");
        ClientVerifier clientVerifier = new ClientVerifier(this.getContext());
        clientVerifier.setAcceptBodyMethod(true);
        clientAuthenticator.setVerifier((Verifier)clientVerifier);
        clientAuthenticator.setNext(AccessTokenServerResource.class);
        router.attach("/token", (Restlet)clientAuthenticator);
        router.attach("/token_auth", TokenAuthServerResource.class);
        Directory resources = new Directory(this.getContext(), "clap://system/resources");
        router.attach("", (Restlet)resources);
        return router;
    }
}

