/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.fileupload;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.restlet.resource.ServerResource;

public class FileUploadServerResource
extends ServerResource {
    @Post
    public Representation accept(Representation entity) throws Exception {
        StringRepresentation result = null;
        if (entity != null && MediaType.MULTIPART_FORM_DATA.equals((Object)entity.getMediaType(), true)) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(1000240);
            RestletFileUpload upload = new RestletFileUpload((FileItemFactory)factory);
            FileItemIterator fileIterator = upload.getItemIterator(entity);
            boolean found = false;
            while (fileIterator.hasNext() && !found) {
                FileItemStream fi = fileIterator.next();
                if (!fi.getFieldName().equals("fileToUpload")) continue;
                found = true;
                StringBuilder sb = new StringBuilder("media type: ");
                sb.append(fi.getContentType()).append("\n");
                sb.append("file name : ");
                sb.append(fi.getName()).append("\n");
                BufferedReader br = new BufferedReader(new InputStreamReader(fi.openStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                sb.append("\n");
                result = new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_PLAIN);
            }
        } else {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        }
        return result;
    }
}

