/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.wadl;

import java.io.IOException;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.example.ext.wadl.BaseResource;
import org.restlet.example.ext.wadl.Item;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.ext.wadl.ResponseInfo;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Post;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ItemsResource
extends BaseResource {
    @Post
    public Representation acceptItem(Representation entity) {
        Representation result = null;
        Form form = new Form(entity);
        String itemName = form.getFirstValue("name");
        String itemDescription = form.getFirstValue("description");
        if (!this.getItems().containsKey(itemName) && this.getItems().putIfAbsent(itemName, new Item(itemName, itemDescription)) == null) {
            this.setStatus(Status.SUCCESS_CREATED);
            StringRepresentation rep = new StringRepresentation((CharSequence)"Item created", MediaType.TEXT_PLAIN);
            rep.setLocationRef(this.getRequest().getResourceRef().getIdentifier() + "/" + itemName);
            result = rep;
        } else {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            result = this.generateErrorRepresentation("Item " + itemName + " already exists.", "1");
        }
        return result;
    }

    protected Representation describe() {
        this.setName("List of items.");
        return super.describe();
    }

    protected void describeGet(MethodInfo info) {
        info.setIdentifier("items");
        info.setDocumentation("Retrieve the list of current items.");
        ResponseInfo response = new ResponseInfo();
        RepresentationInfo repInfo = new RepresentationInfo(MediaType.TEXT_XML);
        repInfo.setXmlElement("items");
        repInfo.setDocumentation("List of items as XML file");
        response.getRepresentations().add(repInfo);
        info.getResponses().add(response);
    }

    protected void describePost(MethodInfo info) {
        info.setIdentifier("create_item");
        info.setDocumentation("To create an item.");
        RepresentationInfo repInfo = new RepresentationInfo(MediaType.APPLICATION_WWW_FORM);
        ParameterInfo param = new ParameterInfo("name", ParameterStyle.PLAIN, "Name of the item");
        repInfo.getParameters().add(param);
        param = new ParameterInfo("description", ParameterStyle.PLAIN, "Description of the item");
        repInfo.getParameters().add(param);
        repInfo.setDocumentation("Web form.");
        info.getRequest().getRepresentations().add(repInfo);
        ResponseInfo response = new ResponseInfo();
        response.getStatuses().add(Status.SUCCESS_CREATED);
        info.getResponses().add(response);
        response = new ResponseInfo();
        response.getStatuses().add(Status.CLIENT_ERROR_NOT_FOUND);
        info.getResponses().add(response);
        repInfo = new RepresentationInfo(MediaType.TEXT_HTML);
        repInfo.setIdentifier("itemError");
        response.getRepresentations().add(repInfo);
    }

    private Representation generateErrorRepresentation(String errorMessage, String errorCode) {
        DomRepresentation result = null;
        try {
            result = new DomRepresentation(MediaType.TEXT_XML);
            Document d = result.getDocument();
            Element eltError = d.createElement("error");
            Element eltCode = d.createElement("code");
            eltCode.appendChild(d.createTextNode(errorCode));
            eltError.appendChild(eltCode);
            Element eltMessage = d.createElement("message");
            eltMessage.appendChild(d.createTextNode(errorMessage));
            eltError.appendChild(eltMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Representation toXml() {
        try {
            DomRepresentation representation = new DomRepresentation(MediaType.TEXT_XML);
            Document d = representation.getDocument();
            Element r = d.createElement("items");
            d.appendChild(r);
            for (Item item : this.getItems().values()) {
                Element eltItem = d.createElement("item");
                Element eltName = d.createElement("name");
                eltName.appendChild(d.createTextNode(item.getName()));
                eltItem.appendChild(eltName);
                Element eltDescription = d.createElement("description");
                eltDescription.appendChild(d.createTextNode(item.getDescription()));
                eltItem.appendChild(eltDescription);
                r.appendChild(eltItem);
            }
            d.normalizeDocument();
            return representation;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

