/**
 * Copyright 2005-2014 Restlet
 * 
 * The contents of this file are subject to the terms of one of the following
 * open source licenses: Apache 2.0 or LGPL 3.0 or LGPL 2.1 or CDDL 1.0 or EPL
 * 1.0 (the "Licenses"). You can select the license that you prefer but you may
 * not use this file except in compliance with one of these Licenses.
 * 
 * You can obtain a copy of the Apache 2.0 license at
 * http://www.opensource.org/licenses/apache-2.0
 * 
 * You can obtain a copy of the LGPL 3.0 license at
 * http://www.opensource.org/licenses/lgpl-3.0
 * 
 * You can obtain a copy of the LGPL 2.1 license at
 * http://www.opensource.org/licenses/lgpl-2.1
 * 
 * You can obtain a copy of the CDDL 1.0 license at
 * http://www.opensource.org/licenses/cddl1
 * 
 * You can obtain a copy of the EPL 1.0 license at
 * http://www.opensource.org/licenses/eclipse-1.0
 * 
 * See the Licenses for the specific language governing permissions and
 * limitations under the Licenses.
 * 
 * Alternatively, you can obtain a royalty free commercial license with less
 * limitations, transferable or non-transferable, directly at
 * http://restlet.com/products/restlet-framework
 * 
 * Restlet is a registered trademark of Restlet S.A.S.
 */

package org.restlet.ext.apispark.internal.model;

import java.util.List;

/**
 * 
 * @author
 */
public class Representation {

    /** Textual description of this representation. */
    private String description;

    /** Name of the representation. */
    private String name;

    /** Reference to its parent type if any. */
    private String parentType;

    /** List of this representation's properties. */
    private List<Property> properties;

    /** Indicates if the representation is structured or not. */
    private boolean raw;

    /** List of variants available for this representation. */
    private List<Variant> variants;

    public String getDescription() {
        return description;
    }

    public String getName() {
        return name;
    }

    public String getParentType() {
        return parentType;
    }

    public List<Property> getProperties() {
        return properties;
    }

    public List<Variant> getVariants() {
        return variants;
    }

    public boolean isRaw() {
        return raw;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentType(String parentType) {
        this.parentType = parentType;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void setRaw(boolean raw) {
        this.raw = raw;
    }

    public void setVariants(List<Variant> variants) {
        this.variants = variants;
    }
}
