/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.engine.connector.ConnectorHelper;
import org.restlet.ext.apispark.internal.info.ApplicationInfo;
import org.restlet.ext.apispark.internal.info.DocumentationInfo;
import org.restlet.ext.apispark.internal.info.MethodInfo;
import org.restlet.ext.apispark.internal.info.ParameterInfo;
import org.restlet.ext.apispark.internal.info.ParameterStyle;
import org.restlet.ext.apispark.internal.info.PropertyInfo;
import org.restlet.ext.apispark.internal.info.RepresentationInfo;
import org.restlet.ext.apispark.internal.info.ResourceInfo;
import org.restlet.ext.apispark.internal.info.ResponseInfo;
import org.restlet.ext.apispark.internal.model.Body;
import org.restlet.ext.apispark.internal.model.Contract;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Method;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.Parameter;
import org.restlet.ext.apispark.internal.model.PathVariable;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Resource;
import org.restlet.ext.apispark.internal.model.Variant;
import org.restlet.ext.apispark.internal.reflect.ReflectUtils;
import org.restlet.resource.ClientResource;
import org.restlet.resource.Directory;
import org.restlet.resource.Finder;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Filter;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.TemplateRoute;
import org.restlet.routing.VirtualHost;

public class Introspector {
    protected static Logger LOGGER = Context.getCurrentLogger();
    private Definition definition;

    private static void addRepresentations(Map<String, RepresentationInfo> mapReps, List<RepresentationInfo> representations) {
        if (representations != null) {
            for (RepresentationInfo r : representations) {
                if (mapReps.containsKey(r.getIdentifier())) continue;
                mapReps.put(r.getIdentifier(), r);
            }
        }
    }

    private static void addResources(ApplicationInfo application, Contract contract, List<ResourceInfo> resources, String basePath, Map<String, RepresentationInfo> mapReps) {
        for (ResourceInfo ri : resources) {
            Resource resource = new Resource();
            resource.setDescription(Introspector.toString(ri.getDocumentations()));
            resource.setName(ri.getIdentifier());
            if (ri.getPath() != null) {
                if (basePath != null) {
                    if (basePath.endsWith("/")) {
                        if (ri.getPath().startsWith("/")) {
                            resource.setResourcePath(basePath + ri.getPath().substring(1));
                        } else {
                            resource.setResourcePath(basePath + ri.getPath());
                        }
                    } else if (ri.getPath().startsWith("/")) {
                        resource.setResourcePath(basePath + ri.getPath());
                    } else {
                        resource.setResourcePath(basePath + "/" + ri.getPath());
                    }
                } else if (ri.getPath().startsWith("/")) {
                    resource.setResourcePath(ri.getPath());
                } else {
                    resource.setResourcePath("/" + ri.getPath());
                }
            }
            if (!ri.getChildResources().isEmpty()) {
                Introspector.addResources(application, contract, ri.getChildResources(), resource.getResourcePath(), mapReps);
            }
            LOGGER.info("Resource " + ri.getPath() + " added.");
            if (ri.getMethods().isEmpty()) {
                LOGGER.warning("Resource " + ri.getIdentifier() + " has no methods.");
                continue;
            }
            resource.setPathVariables(new ArrayList<PathVariable>());
            for (ParameterInfo pi : ri.getParameters()) {
                if (!ParameterStyle.TEMPLATE.equals((Object)pi.getStyle())) continue;
                PathVariable pathVariable = new PathVariable();
                pathVariable.setDescription(Introspector.toString(pi.getDocumentations()));
                pathVariable.setName(pi.getName());
                resource.getPathVariables().add(pathVariable);
            }
            resource.setOperations(new ArrayList<Operation>());
            for (MethodInfo mi : ri.getMethods()) {
                Body body;
                Parameter parameter;
                LOGGER.info("Method " + mi.getMethod().getName() + " added.");
                Operation operation = new Operation();
                operation.setDescription(Introspector.toString(mi.getDocumentations()));
                operation.setName(mi.getMethod().getName());
                operation.setMethod(new Method());
                operation.getMethod().setDescription(mi.getMethod().getDescription());
                operation.getMethod().setName(mi.getMethod().getName());
                operation.setHeaders(new ArrayList<Parameter>());
                operation.setQueryParameters(new ArrayList<Parameter>());
                if (mi.getRequest() != null) {
                    for (ParameterInfo pi : mi.getRequest().getParameters()) {
                        if (ParameterStyle.HEADER.equals((Object)pi.getStyle())) {
                            parameter = new Parameter();
                            parameter.setAllowMultiple(pi.isRepeating());
                            parameter.setDefaultValue(pi.getDefaultValue());
                            parameter.setDescription(Introspector.toString(pi.getDocumentations()));
                            parameter.setName(pi.getName());
                            parameter.setPossibleValues(new ArrayList<String>());
                            parameter.setRequired(pi.isRequired());
                            operation.getHeaders().add(parameter);
                            continue;
                        }
                        if (!ParameterStyle.QUERY.equals((Object)pi.getStyle())) continue;
                        parameter = new Parameter();
                        parameter.setAllowMultiple(pi.isRepeating());
                        parameter.setDefaultValue(pi.getDefaultValue());
                        parameter.setDescription(Introspector.toString(pi.getDocumentations()));
                        parameter.setName(pi.getName());
                        parameter.setPossibleValues(new ArrayList<String>());
                        parameter.setRequired(pi.isRequired());
                        operation.getQueryParameters().add(parameter);
                    }
                }
                for (ParameterInfo pi : mi.getParameters()) {
                    if (ParameterStyle.HEADER.equals((Object)pi.getStyle())) {
                        parameter = new Parameter();
                        parameter.setAllowMultiple(pi.isRepeating());
                        parameter.setDefaultValue(pi.getDefaultValue());
                        parameter.setDescription(Introspector.toString(pi.getDocumentations()));
                        parameter.setName(pi.getName());
                        parameter.setPossibleValues(new ArrayList<String>());
                        parameter.setRequired(pi.isRequired());
                        operation.getHeaders().add(parameter);
                        continue;
                    }
                    if (!ParameterStyle.QUERY.equals((Object)pi.getStyle())) continue;
                    parameter = new Parameter();
                    parameter.setAllowMultiple(pi.isRepeating());
                    parameter.setDefaultValue(pi.getDefaultValue());
                    parameter.setDescription(Introspector.toString(pi.getDocumentations()));
                    parameter.setName(pi.getName());
                    parameter.setPossibleValues(new ArrayList<String>());
                    parameter.setRequired(pi.isRequired());
                    operation.getQueryParameters().add(parameter);
                }
                if (mi.getRequest() != null && mi.getRequest().getRepresentations() != null && !mi.getRequest().getRepresentations().isEmpty()) {
                    Introspector.addRepresentations(mapReps, mi.getRequest().getRepresentations());
                    body = new Body();
                    body.setRepresentation(mi.getRequest().getRepresentations().get(0).getName());
                    operation.setInRepresentation(body);
                }
                if (mi.getResponses() != null && !mi.getResponses().isEmpty()) {
                    operation.setResponses(new ArrayList<org.restlet.ext.apispark.internal.model.Response>());
                    body = new Body();
                    if (!mi.getResponse().getRepresentations().isEmpty()) {
                        body.setRepresentation(mi.getResponse().getRepresentations().get(0).getName());
                    }
                    operation.setOutRepresentation(body);
                    for (ResponseInfo rio : mi.getResponses()) {
                        Introspector.addRepresentations(mapReps, rio.getRepresentations());
                        if (rio.getStatuses().isEmpty()) continue;
                        Status status = rio.getStatuses().get(0);
                        org.restlet.ext.apispark.internal.model.Response response = new org.restlet.ext.apispark.internal.model.Response();
                        response.setBody(body);
                        response.setCode(status.getCode());
                        response.setName(Introspector.toString(rio.getDocumentations()));
                        response.setDescription(Introspector.toString(rio.getDocumentations()));
                        response.setMessage(status.getDescription());
                        operation.getResponses().add(response);
                    }
                }
                resource.getOperations().add(operation);
            }
            contract.getResources().add(resource);
        }
    }

    private static Application getApplication(String className) {
        Application result = null;
        if (className == null) {
            return result;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            if (Application.class.isAssignableFrom(clazz)) {
                result = (Application)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                LOGGER.log(Level.SEVERE, className + " does not seem to a valid subclass of " + Application.class.getName() + " class.");
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Cannot locate the application class.", e);
        }
        catch (InstantiationException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the application class.", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the application class.", e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Check that the application class has an empty constructor.", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the application class.", e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.SEVERE, "Check that the application class has an empty constructor.", e);
        }
        catch (SecurityException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the application class.", e);
        }
        return result;
    }

    protected static ApplicationInfo getApplicationInfo(Application application, Reference baseRef) {
        ApplicationInfo applicationInfo = new ApplicationInfo();
        if (application.getName() != null && !application.getName().isEmpty()) {
            DocumentationInfo doc = null;
            if (applicationInfo.getDocumentations().isEmpty()) {
                doc = new DocumentationInfo();
                applicationInfo.getDocumentations().add(doc);
            } else {
                doc = applicationInfo.getDocumentations().get(0);
            }
            applicationInfo.setName(application.getName());
            doc.setTitle(application.getName());
        }
        applicationInfo.getResources().setBaseRef(baseRef);
        applicationInfo.getResources().setResources(Introspector.getResourceInfos(applicationInfo, Introspector.getNextRouter(application.getInboundRoot())));
        return applicationInfo;
    }

    private static Component getComponent(String className) {
        Component result = null;
        if (className == null) {
            return result;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            if (Component.class.isAssignableFrom(clazz)) {
                result = (Component)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                LOGGER.log(Level.SEVERE, className + " does not seem to a valid subclass of " + Component.class.getName() + " class.");
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Cannot locate the component class.", e);
        }
        catch (InstantiationException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the component class.", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the component class.", e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Check that the component class has an empty constructor.", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the component class.", e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.SEVERE, "Check that the component class has an empty constructor.", e);
        }
        catch (SecurityException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the component class.", e);
        }
        return result;
    }

    private static Application getNextApplication(Restlet current) {
        Application result;
        block2: {
            Route route;
            block3: {
                block1: {
                    result = null;
                    if (!(current instanceof Application)) break block1;
                    result = (Application)current;
                    break block2;
                }
                if (!(current instanceof Filter)) break block3;
                result = Introspector.getNextApplication(((Filter)current).getNext());
                break block2;
            }
            if (!(current instanceof Router)) break block2;
            Router router = (Router)current;
            Iterator i$ = router.getRoutes().iterator();
            while (i$.hasNext() && (result = Introspector.getNextApplication((route = (Route)i$.next()).getNext())) == null) {
            }
        }
        return result;
    }

    private static Router getNextRouter(Restlet current) {
        Router result = null;
        if (current instanceof Router) {
            result = (Router)current;
        } else if (current instanceof Filter) {
            result = Introspector.getNextRouter(((Filter)current).getNext());
        }
        return result;
    }

    private static String getParameter(String[] args, int index) {
        if (index >= args.length) {
            return null;
        }
        String value = args[index];
        if ("-s".equals(value) || "-u".equals(value) || "-p".equals(value) || "-d".equals(value) || "-c".equals(value)) {
            value = null;
        }
        return value;
    }

    private static ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Filter filter, String path) {
        return Introspector.getResourceInfo(applicationInfo, filter.getNext(), path);
    }

    private static ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Finder finder, String path) {
        ResourceInfo result = null;
        Finder resource = null;
        if (finder instanceof Directory) {
            resource = finder;
        } else {
            ServerResource sr = finder.find(null, null);
            if (sr != null) {
                Request request = new Request();
                Response response = new Response(request);
                sr.setRequest(request);
                sr.setResponse(response);
                sr.updateAllowedMethods();
                resource = sr;
            }
        }
        if (resource != null) {
            result = new ResourceInfo();
            ResourceInfo.describe(applicationInfo, result, resource, path);
        }
        return result;
    }

    private static ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Restlet restlet, String path) {
        ResourceInfo result = null;
        if (restlet instanceof Finder) {
            result = Introspector.getResourceInfo(applicationInfo, (Finder)restlet, path);
        } else if (restlet instanceof Router) {
            result = new ResourceInfo();
            result.setPath(path);
            result.setChildResources(Introspector.getResourceInfos(applicationInfo, (Router)restlet));
        } else if (restlet instanceof Filter) {
            result = Introspector.getResourceInfo(applicationInfo, (Filter)restlet, path);
        }
        return result;
    }

    private static ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Route route, String basePath) {
        ResourceInfo result = null;
        if (route instanceof TemplateRoute) {
            TemplateRoute templateRoute = (TemplateRoute)route;
            String path = templateRoute.getTemplate().getPattern();
            if (path.startsWith("/") && basePath.endsWith("/")) {
                path = path.substring(1);
            }
            result = Introspector.getResourceInfo(applicationInfo, route.getNext(), path);
        }
        return result;
    }

    private static List<ResourceInfo> getResourceInfos(ApplicationInfo applicationInfo, Router router) {
        ArrayList<ResourceInfo> result = new ArrayList<ResourceInfo>();
        if (router != null) {
            ResourceInfo resourceInfo;
            for (Route route : router.getRoutes()) {
                ResourceInfo resourceInfo2 = Introspector.getResourceInfo(applicationInfo, route, "/");
                if (resourceInfo2 == null) continue;
                result.add(resourceInfo2);
            }
            if (router.getDefaultRoute() != null && (resourceInfo = Introspector.getResourceInfo(applicationInfo, router.getDefaultRoute(), "/")) != null) {
                result.add(resourceInfo);
            }
        }
        return result;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static void main(String[] args) {
        block24: {
            String ulogin = null;
            String upwd = null;
            String serviceUrl = null;
            String appName = null;
            String compName = null;
            String definitionId = null;
            LOGGER.fine("Get parameters");
            for (int i = 0; i < args.length; ++i) {
                if ("-h".equals(args[i])) {
                    Introspector.printHelp();
                    System.exit(0);
                    continue;
                }
                if ("-u".equals(args[i])) {
                    ulogin = Introspector.getParameter(args, ++i);
                    continue;
                }
                if ("-p".equals(args[i])) {
                    upwd = Introspector.getParameter(args, ++i);
                    continue;
                }
                if ("-s".equals(args[i])) {
                    serviceUrl = Introspector.getParameter(args, ++i);
                    continue;
                }
                if ("-c".equals(args[i])) {
                    compName = Introspector.getParameter(args, ++i);
                    continue;
                }
                if ("-d".equals(args[i])) {
                    definitionId = Introspector.getParameter(args, ++i);
                    continue;
                }
                appName = args[i];
            }
            LOGGER.fine("Check parameters");
            if (Introspector.isEmpty(serviceUrl)) {
                serviceUrl = "https://apispark.com/";
            }
            if (!serviceUrl.endsWith("/")) {
                serviceUrl = serviceUrl + "/";
            }
            if (Introspector.isEmpty(ulogin) || Introspector.isEmpty(upwd) || Introspector.isEmpty(appName)) {
                Introspector.printHelp();
                System.exit(1);
            }
            Application application = Introspector.getApplication(appName);
            Component component = Introspector.getComponent(compName);
            if (application != null) {
                LOGGER.fine("Instantiate introspector");
                Introspector i = new Introspector(component, application);
                try {
                    ClientResource cr = new ClientResource(serviceUrl + "definitions");
                    cr.setChallengeResponse(ChallengeScheme.HTTP_BASIC, ulogin, upwd);
                    LOGGER.fine("Generate documentation");
                    Definition definition = i.getDefinition();
                    if (definitionId == null) {
                        LOGGER.fine("Create a new documentation");
                        cr.post((Object)definition, MediaType.APPLICATION_JSON);
                    } else {
                        cr.addSegment(definitionId);
                        LOGGER.fine("Update the documentation of " + cr.getReference().toString());
                        cr.put((Object)definition, MediaType.APPLICATION_JSON);
                    }
                    LOGGER.fine("Display result");
                    System.out.println("Process successfully achieved.");
                    if (cr.getResponseEntity() != null && cr.getResponseEntity().isAvailable()) {
                        try {
                            cr.getResponseEntity().write((OutputStream)System.out);
                            System.out.println();
                        }
                        catch (IOException e) {
                            LOGGER.warning("Request successfully achieved by the server, but it's response cannot be printed");
                        }
                    }
                    if (cr.getLocationRef() != null) {
                        System.out.println("Your Web API documentation is accessible at this URL: " + cr.getLocationRef());
                    }
                    break block24;
                }
                catch (ResourceException e) {
                    if (e.getStatus().isConnectorError()) {
                        LOGGER.severe("Cannot reach the remote service, could you check your network connection?");
                        LOGGER.severe("Could you check that the following service is up? " + serviceUrl);
                    } else if (e.getStatus().isClientError()) {
                        LOGGER.severe("Check that you provide valid credentials, or valid service url.");
                    } else if (e.getStatus().isServerError()) {
                        LOGGER.severe("The server side encounters some issues, please try later.");
                    }
                    break block24;
                }
            }
            LOGGER.severe("Please provide a valid application class name.");
        }
    }

    private static void printHelp() {
        PrintStream o = System.out;
        o.println("SYNOPSIS");
        Introspector.printSynopsis(o, Introspector.class, "[options] APPLICATION");
        o.println("DESCRIPTION");
        Introspector.printSentence(o, "Publish to the APISpark platform the description of your Web API, represented by APPLICATION,", "the full name of your Restlet application class.");
        Introspector.printSentence(o, "If the whole process is successfull, it displays the url of the corresponding documentation.");
        o.println("OPTIONS");
        Introspector.printOption(o, "-h", "Prints this help.");
        Introspector.printOption(o, "-u", "The mandatory APISpark user name.");
        Introspector.printOption(o, "-p", "The mandatory APISpark user secret key.");
        Introspector.printOption(o, "-s", "The optional APISpark platform URL (by default https://apispark.com).");
        Introspector.printOption(o, "-c", "The optional full name of your Restlet Component class.", "This allows to collect some other data, such as the endpoint.");
        Introspector.printOption(o, "-d", "The optional identifier of an existing definition hosted by APISpark you want to update with this new documentation.");
        o.println("LOGGING");
        Introspector.printSentence(o, "You can get a detailled log of the process using the JDK's API.", "See the official documentation: http://docs.oracle.com/javase/7/docs/technotes/guides/logging/overview.html", "Here is the name of the used Logger: " + Introspector.class.getName());
    }

    private static void printOption(PrintStream o, String option, String ... strings) {
        Introspector.printSentence(o, 7, option);
        Introspector.printSentence(o, 14, strings);
    }

    private static void printSentence(PrintStream o, int shift, String ... strings) {
        int blockLength = 80 - shift - 1;
        String tab = "";
        for (int i = 0; i < shift; ++i) {
            tab = tab.concat(" ");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(strings[i]);
        }
        String sentence = sb.toString();
        int index = 0;
        while (index < sentence.length() - 1) {
            o.print(tab);
            int length = Math.min(index + blockLength, sentence.length() - 1);
            if (length - index < blockLength) {
                o.println(sentence.substring(index));
                index = length + 1;
                continue;
            }
            if (sentence.charAt(length) == ' ') {
                o.println(sentence.substring(index, length));
                index = length + 1;
                continue;
            }
            if ((length = sentence.substring(index, length - 1).lastIndexOf(32)) != -1) {
                o.println(sentence.substring(index, index + length));
                index += length + 1;
                continue;
            }
            length = sentence.substring(index).indexOf(32);
            if (length != -1) {
                o.println(sentence.substring(index, index + length));
                index += length + 1;
                continue;
            }
            o.println(sentence.substring(index));
            index = sentence.length();
        }
    }

    private static void printSentence(PrintStream o, String ... strings) {
        Introspector.printSentence(o, 7, strings);
    }

    private static void printSynopsis(PrintStream o, Class<?> clazz, String command) {
        Introspector.printSentence(o, 7, clazz.getName(), command);
    }

    private static Definition toDefinition(ApplicationInfo application) {
        Definition result = null;
        if (application != null) {
            RepresentationInfo r;
            result = new Definition();
            result.setVersion(application.getVersion());
            if (application.getResources().getBaseRef() != null) {
                result.setEndpoint(application.getResources().getBaseRef().toString());
            }
            Contract contract = new Contract();
            result.setContract(contract);
            contract.setDescription(Introspector.toString(application.getDocumentations()));
            contract.setName(application.getName());
            if (contract.getName() == null || contract.getName().isEmpty()) {
                contract.setName(application.getClass().getName());
                LOGGER.log(Level.WARNING, "Please provide a name to your application, used " + contract.getName() + " by default.");
            }
            LOGGER.info("Contract " + contract.getName() + " added.");
            contract.setResources(new ArrayList<Resource>());
            HashMap<String, RepresentationInfo> mapReps = new HashMap<String, RepresentationInfo>();
            Introspector.addResources(application, contract, application.getResources().getResources(), result.getEndpoint(), mapReps);
            ArrayList<String> protocols = new ArrayList<String>();
            for (ConnectorHelper helper : Engine.getInstance().getRegisteredServers()) {
                for (Protocol protocol : helper.getProtocols()) {
                    if (protocols.contains(protocol.getName())) continue;
                    LOGGER.info("Protocol " + protocol.getName() + " added.");
                    protocols.add(protocol.getName());
                }
            }
            contract.setRepresentations(new ArrayList<Representation>());
            for (RepresentationInfo ri : application.getRepresentations()) {
                if (mapReps.containsKey(ri.getIdentifier())) continue;
                mapReps.put(ri.getIdentifier(), ri);
            }
            ArrayList<RepresentationInfo> toBeAdded = new ArrayList<RepresentationInfo>();
            for (RepresentationInfo ri : mapReps.values()) {
                Class<?> parentType = ri.getParentType();
                if (ri.getParentType() != null && !mapReps.containsKey(parentType.getName())) {
                    RepresentationInfo r2 = new RepresentationInfo(ri.getMediaType());
                    r2.setType(parentType);
                    toBeAdded.add(r2);
                }
                for (PropertyInfo pi : ri.getProperties()) {
                    if (pi.getType() == null || mapReps.containsKey(pi.getType().getName()) || toBeAdded.contains(pi.getType())) continue;
                    r = new RepresentationInfo(ri.getMediaType());
                    r.setType(pi.getType());
                    toBeAdded.add(r);
                }
            }
            while (!toBeAdded.isEmpty()) {
                RepresentationInfo[] tab = new RepresentationInfo[toBeAdded.size()];
                toBeAdded.toArray(tab);
                toBeAdded.clear();
                for (int i = 0; i < tab.length; ++i) {
                    RepresentationInfo current = tab[i];
                    if (ReflectUtils.isJdkClass(current.getType()) || mapReps.containsKey(current.getName())) continue;
                    RepresentationInfo ri = RepresentationInfo.introspect(current.getType(), current.getMediaType());
                    mapReps.put(ri.getIdentifier(), ri);
                    Class<?> parentType = ri.getParentType();
                    if (parentType != null && !mapReps.containsKey(parentType.getName())) {
                        r = new RepresentationInfo(ri.getMediaType());
                        r.setType(parentType);
                        toBeAdded.add(r);
                    }
                    for (PropertyInfo prop : ri.getProperties()) {
                        if (prop.getType() == null || mapReps.containsKey(prop.getType().getName()) || toBeAdded.contains(prop.getType())) continue;
                        RepresentationInfo r3 = new RepresentationInfo(ri.getMediaType());
                        r3.setType(prop.getType());
                        toBeAdded.add(r3);
                    }
                }
            }
            for (RepresentationInfo ri : mapReps.values()) {
                if (ReflectUtils.isJdkClass(ri.getType())) continue;
                LOGGER.info("Representation " + ri.getName() + " added.");
                Representation rep = new Representation();
                rep.setDescription(Introspector.toString(ri.getDocumentations()));
                rep.setName(ri.getName());
                if (ri.getMediaType() != null) {
                    Variant variant = new Variant();
                    variant.setDataType(ri.getMediaType().getName());
                    rep.setVariants(new ArrayList<Variant>());
                    rep.getVariants().add(variant);
                }
                rep.setProperties(new ArrayList<Property>());
                for (PropertyInfo pi : ri.getProperties()) {
                    LOGGER.info("Property " + pi.getName() + " added.");
                    Property p = new Property();
                    p.setDefaultValue(pi.getDefaultValue());
                    p.setDescription(pi.getDescription());
                    p.setMax(pi.getMax());
                    p.setMaxOccurs(pi.getMaxOccurs());
                    p.setMin(pi.getMin());
                    p.setMinOccurs(pi.getMinOccurs());
                    p.setName(pi.getName());
                    p.setPossibleValues(pi.getPossibleValues());
                    if (pi.getType() != null) {
                        p.setType(pi.getType().getSimpleName());
                    }
                    p.setUniqueItems(pi.isUniqueItems());
                    rep.getProperties().add(p);
                }
                rep.setRaw(ri.isRaw());
                contract.getRepresentations().add(rep);
            }
        }
        return result;
    }

    private static String toString(List<DocumentationInfo> dis) {
        StringBuilder d = new StringBuilder();
        for (DocumentationInfo doc : dis) {
            d.append(doc.getTextContent());
        }
        return d.toString();
    }

    public Introspector(Application application) {
        this(null, application);
    }

    public Introspector(Component component, Application application) {
        this.definition = Introspector.toDefinition(Introspector.getApplicationInfo(application, null));
        if (component != null && this.definition != null) {
            LOGGER.fine("Look for the endpoint.");
            String endpoint = null;
            endpoint = this.getEndpoint(component.getDefaultHost(), application);
            for (int i = 0; endpoint == null && i < component.getHosts().size(); ++i) {
                VirtualHost virtualHost = (VirtualHost)component.getHosts().get(i);
                endpoint = this.getEndpoint(virtualHost, application);
            }
            this.definition.setEndpoint(endpoint);
        }
    }

    public Definition getDefinition() {
        return this.definition;
    }

    private String getEndpoint(VirtualHost virtualHost, Application application) {
        String result = null;
        for (Route route : virtualHost.getRoutes()) {
            Application app;
            if (route.getNext() == null || (app = Introspector.getNextApplication(route.getNext())) == null || !application.getClass().equals(app.getClass())) continue;
            String hostDomain = null;
            if (virtualHost.getHostDomain() != null && !".*".equals(virtualHost.getHostDomain())) {
                hostDomain = virtualHost.getHostDomain().contains("|") ? virtualHost.getHostDomain().split("|")[0] : virtualHost.getHostDomain();
            }
            if (hostDomain == null) continue;
            Protocol scheme = null;
            if (!".*".equals(virtualHost.getHostScheme())) {
                scheme = Protocol.valueOf((String)virtualHost.getHostScheme());
            }
            if (scheme == null) {
                scheme = Protocol.HTTP;
            }
            Reference ref = new Reference();
            ref.setProtocol(scheme);
            ref.setHostDomain(hostDomain);
            if (route instanceof TemplateRoute) {
                ref.addSegment(((TemplateRoute)route).getTemplate().getPattern());
            }
            try {
                ref.setHostPort(Integer.valueOf(Integer.parseInt(virtualHost.getHostPort())));
            }
            catch (Exception e) {
                // empty catch block
            }
            result = ref.toString();
        }
        return result;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }
}

