/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.info;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.ext.apispark.internal.info.DocumentationInfo;
import org.restlet.ext.apispark.internal.info.DocumentedInfo;
import org.restlet.ext.apispark.internal.info.ParameterInfo;
import org.restlet.ext.apispark.internal.info.ParameterStyle;
import org.restlet.ext.apispark.internal.info.RepresentationInfo;
import org.restlet.ext.apispark.internal.info.RequestInfo;
import org.restlet.ext.apispark.internal.info.ResponseInfo;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.restlet.service.MetadataService;

public class MethodInfo
extends DocumentedInfo {
    private String identifier;
    private Method method;
    private List<ParameterInfo> parameters;
    private RequestInfo request;
    private List<ResponseInfo> responses;
    private Reference targetRef;

    public static void describeAnnotations(MethodInfo info, ServerResource resource) {
        List annotations;
        MetadataService metadataService = resource.getMetadataService();
        List list = annotations = resource.isAnnotated() ? AnnotationUtils.getInstance().getAnnotations(resource.getClass()) : null;
        if (annotations != null && metadataService != null) {
            for (AnnotationInfo annotationInfo : annotations) {
                try {
                    List responseVariants;
                    Class outputClass;
                    if (!info.getMethod().equals((Object)annotationInfo.getRestletMethod())) continue;
                    Class[] classes = annotationInfo.getJavaInputTypes();
                    Class inputClass = classes != null && classes.length > 0 ? classes[0] : null;
                    List requestVariants = annotationInfo.getRequestVariants(resource.getMetadataService(), resource.getConverterService());
                    if (requestVariants != null) {
                        for (Variant variant : requestVariants) {
                            if (variant.getMediaType() == null || info.getRequest() != null && info.getRequest().getRepresentations().contains(variant)) continue;
                            if (info.getRequest() == null) {
                                info.setRequest(new RequestInfo());
                            }
                            RepresentationInfo representationInfo = RepresentationInfo.describe(info, inputClass, variant);
                            info.getRequest().getRepresentations().add(representationInfo);
                        }
                    }
                    if (annotationInfo.getQuery() != null) {
                        Form form = new Form(annotationInfo.getQuery());
                        for (Parameter parameter : form) {
                            ParameterInfo pi = new ParameterInfo(parameter.getName(), true, null, ParameterStyle.QUERY, "Value: " + parameter.getValue());
                            pi.setDefaultValue(parameter.getValue());
                            info.getParameters().add(pi);
                        }
                    }
                    if ((outputClass = annotationInfo.getJavaOutputType()) != null && (responseVariants = annotationInfo.getResponseVariants(resource.getMetadataService(), resource.getConverterService())) != null) {
                        for (Variant variant : responseVariants) {
                            if (variant.getMediaType() == null || info.getResponse().getRepresentations().contains(variant)) continue;
                            RepresentationInfo representationInfo = RepresentationInfo.describe(info, outputClass, variant);
                            info.getResponse().getRepresentations().add(representationInfo);
                        }
                    }
                    if (!info.getResponse().getStatuses().isEmpty()) continue;
                    info.getResponse().getStatuses().add(Status.SUCCESS_OK);
                    info.getResponse().setDocumentation("Success");
                }
                catch (IOException e) {
                    throw new ResourceException((Throwable)e);
                }
            }
        }
    }

    public MethodInfo() {
    }

    public MethodInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public MethodInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public MethodInfo(String documentation) {
        super(documentation);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Method getMethod() {
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParameterInfo> getParameters() {
        List<ParameterInfo> p = this.parameters;
        if (p == null) {
            MethodInfo methodInfo = this;
            synchronized (methodInfo) {
                p = this.parameters;
                if (p == null) {
                    this.parameters = p = new ArrayList<ParameterInfo>();
                }
            }
        }
        return p;
    }

    public RequestInfo getRequest() {
        return this.request;
    }

    public ResponseInfo getResponse() {
        if (this.getResponses().isEmpty()) {
            this.getResponses().add(new ResponseInfo());
        }
        return this.getResponses().get(this.getResponses().size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResponseInfo> getResponses() {
        List<ResponseInfo> r = this.responses;
        if (r == null) {
            MethodInfo methodInfo = this;
            synchronized (methodInfo) {
                r = this.responses;
                if (r == null) {
                    this.responses = r = new ArrayList<ResponseInfo>();
                }
            }
        }
        return r;
    }

    public Reference getTargetRef() {
        return this.targetRef;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setMethod(Method name) {
        this.method = name;
    }

    public void setParameters(List<ParameterInfo> parameters) {
        this.parameters = parameters;
    }

    public void setRequest(RequestInfo request) {
        this.request = request;
    }

    public void setResponses(List<ResponseInfo> responses) {
        this.responses = responses;
    }

    public void setTargetRef(Reference targetRef) {
        this.targetRef = targetRef;
    }
}

