/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.info;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.ext.apispark.internal.info.ApplicationInfo;
import org.restlet.ext.apispark.internal.info.DocumentationInfo;
import org.restlet.ext.apispark.internal.info.DocumentedInfo;
import org.restlet.ext.apispark.internal.info.MethodInfo;
import org.restlet.ext.apispark.internal.info.ParameterInfo;
import org.restlet.ext.apispark.internal.info.ParameterStyle;
import org.restlet.ext.apispark.internal.info.ResourcesInfo;
import org.restlet.resource.Directory;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Template;

public class ResourceInfo
extends DocumentedInfo {
    private List<ResourceInfo> childResources;
    private String identifier;
    private List<MethodInfo> methods;
    private List<ParameterInfo> parameters;
    private String path;
    private MediaType queryType;
    private List<Reference> type;

    public static void describe(ApplicationInfo applicationInfo, ResourceInfo info, Object resource, String path) {
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        info.setPath(path);
        if (path != null) {
            Template template = new Template(path);
            for (String variable : template.getVariableNames()) {
                ParameterInfo param = new ParameterInfo(variable, ParameterStyle.TEMPLATE, (String)null);
                info.getParameters().add(param);
            }
        }
        ArrayList<Method> methodsList = new ArrayList<Method>();
        if (resource instanceof ServerResource) {
            ((ServerResource)resource).updateAllowedMethods();
            methodsList.addAll(((ServerResource)resource).getAllowedMethods());
        } else if (resource instanceof Directory) {
            Directory directory = (Directory)resource;
            methodsList.add(Method.GET);
            if (directory.isModifiable()) {
                methodsList.add(Method.DELETE);
                methodsList.add(Method.PUT);
            }
        }
        Method.sort(methodsList);
        List<MethodInfo> methods = info.getMethods();
        for (Method method : methodsList) {
            MethodInfo methodInfo = new MethodInfo();
            methods.add(methodInfo);
            methodInfo.setMethod(method);
            if (!(resource instanceof ServerResource)) continue;
            MethodInfo.describeAnnotations(methodInfo, (ServerResource)resource);
        }
    }

    public ResourceInfo() {
    }

    public ResourceInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public ResourceInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public ResourceInfo(String documentation) {
        super(documentation);
    }

    public ApplicationInfo createApplication() {
        String titleResource;
        ApplicationInfo result = new ApplicationInfo();
        if (!this.getDocumentations().isEmpty() && (titleResource = this.getDocumentations().get(0).getTitle()) != null && !"".equals(titleResource)) {
            DocumentationInfo doc = null;
            if (result.getDocumentations().isEmpty()) {
                doc = new DocumentationInfo();
                result.getDocumentations().add(doc);
            } else {
                doc = result.getDocumentations().get(0);
            }
            doc.setTitle(titleResource);
        }
        ResourcesInfo resources = new ResourcesInfo();
        result.setResources(resources);
        resources.getResources().add(this);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceInfo> getChildResources() {
        List<ResourceInfo> r = this.childResources;
        if (r == null) {
            ResourceInfo resourceInfo = this;
            synchronized (resourceInfo) {
                r = this.childResources;
                if (r == null) {
                    this.childResources = r = new ArrayList<ResourceInfo>();
                }
            }
        }
        return r;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MethodInfo> getMethods() {
        List<MethodInfo> m = this.methods;
        if (m == null) {
            ResourceInfo resourceInfo = this;
            synchronized (resourceInfo) {
                m = this.methods;
                if (m == null) {
                    this.methods = m = new ArrayList<MethodInfo>();
                }
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParameterInfo> getParameters() {
        List<ParameterInfo> p = this.parameters;
        if (p == null) {
            ResourceInfo resourceInfo = this;
            synchronized (resourceInfo) {
                p = this.parameters;
                if (p == null) {
                    this.parameters = p = new ArrayList<ParameterInfo>();
                }
            }
        }
        return p;
    }

    public String getPath() {
        return this.path;
    }

    public MediaType getQueryType() {
        return this.queryType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Reference> getType() {
        List<Reference> t = this.type;
        if (t == null) {
            ResourceInfo resourceInfo = this;
            synchronized (resourceInfo) {
                t = this.type;
                if (t == null) {
                    this.type = t = new ArrayList<Reference>();
                }
            }
        }
        return t;
    }

    public void setChildResources(List<ResourceInfo> resources) {
        this.childResources = resources;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setMethods(List<MethodInfo> methods) {
        this.methods = methods;
    }

    public void setParameters(List<ParameterInfo> parameters) {
        this.parameters = parameters;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setQueryType(MediaType queryType) {
        this.queryType = queryType;
    }

    public void setType(List<Reference> type) {
        this.type = type;
    }
}

