/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.ext.apispark.FirewallFilter;
import org.restlet.ext.apispark.internal.firewall.handler.BlockingHandler;
import org.restlet.ext.apispark.internal.firewall.handler.policy.PerValueLimitPolicy;
import org.restlet.ext.apispark.internal.firewall.handler.policy.RoleLimitPolicy;
import org.restlet.ext.apispark.internal.firewall.handler.policy.UniqueLimitPolicy;
import org.restlet.ext.apispark.internal.firewall.rule.ConcurrentFirewallCounterRule;
import org.restlet.ext.apispark.internal.firewall.rule.PeriodicFirewallCounterRule;
import org.restlet.ext.apispark.internal.firewall.rule.policy.HostDomainCountingPolicy;
import org.restlet.ext.apispark.internal.firewall.rule.policy.IpAddressCountingPolicy;
import org.restlet.ext.apispark.internal.firewall.rule.policy.UserCountingPolicy;

public class FirewallUtils {
    public static void addHostDomainConcurrencyCounter(FirewallFilter firewall, int limit) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new HostDomainCountingPolicy());
        rule.addHandler(new BlockingHandler(new UniqueLimitPolicy(limit)));
        firewall.add(rule);
    }

    public static void addHostDomainPeriodicCounter(FirewallFilter firewall, int period, int limit) {
        PeriodicFirewallCounterRule rule = new PeriodicFirewallCounterRule(period, new HostDomainCountingPolicy());
        rule.addHandler(new BlockingHandler(new UniqueLimitPolicy(limit)));
        firewall.add(rule);
    }

    public static void addIpAddressesBlackList(FirewallFilter firewall, List<String> blackList) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new IpAddressCountingPolicy());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String ip : blackList) {
            map.put(ip, 0);
        }
        rule.addHandler(new BlockingHandler(new PerValueLimitPolicy(map, Integer.MAX_VALUE)));
        firewall.add(rule);
    }

    public static void addIpAddressesConcurrencyCounter(FirewallFilter firewall, int limit) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new IpAddressCountingPolicy());
        rule.addHandler(new BlockingHandler(new UniqueLimitPolicy(limit)));
        firewall.add(rule);
    }

    public static void addIpAddressesPeriodicCounter(FirewallFilter firewall, int period, int limit) {
        PeriodicFirewallCounterRule rule = new PeriodicFirewallCounterRule(period, new IpAddressCountingPolicy());
        rule.addHandler(new BlockingHandler(new UniqueLimitPolicy(limit)));
        firewall.add(rule);
    }

    public static void addIpAddressesWhiteList(FirewallFilter firewall, List<String> whiteList) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new IpAddressCountingPolicy());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String ip : whiteList) {
            map.put(ip, Integer.MAX_VALUE);
        }
        rule.addHandler(new BlockingHandler(new PerValueLimitPolicy(map, 0)));
        firewall.add(rule);
    }

    public static void addRolesConcurrencyCounter(FirewallFilter firewall, Map<String, Integer> limitsPerRole) {
        FirewallUtils.addRolesConcurrencyCounter(firewall, limitsPerRole, 0);
    }

    public static void addRolesConcurrencyCounter(FirewallFilter firewall, Map<String, Integer> limitsPerRole, int defaultLimit) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new UserCountingPolicy());
        rule.addHandler(new BlockingHandler(new RoleLimitPolicy(limitsPerRole, defaultLimit)));
        firewall.add(rule);
    }

    public static void addRolesPeriodicCounter(FirewallFilter firewall, int period, Map<String, Integer> limitsPerRole) {
        FirewallUtils.addRolesPeriodicCounter(firewall, period, limitsPerRole, 0);
    }

    public static void addRolesPeriodicCounter(FirewallFilter firewall, int period, Map<String, Integer> limitsPerRole, int defaultLimit) {
        PeriodicFirewallCounterRule rule = new PeriodicFirewallCounterRule(period, new UserCountingPolicy());
        rule.addHandler(new BlockingHandler(new RoleLimitPolicy(limitsPerRole, defaultLimit)));
        firewall.add(rule);
    }
}

