/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.engine.Engine;
import org.restlet.ext.apispark.JaxrsIntrospector;
import org.restlet.ext.apispark.internal.conversion.IntrospectionTranslator;
import org.restlet.ext.apispark.internal.conversion.SwaggerUtils;
import org.restlet.ext.apispark.internal.conversion.TranslationException;
import org.restlet.ext.apispark.internal.info.ApplicationInfo;
import org.restlet.ext.apispark.internal.info.DocumentationInfo;
import org.restlet.ext.apispark.internal.info.ResourceInfo;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.utils.IntrospectionUtils;
import org.restlet.resource.Directory;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Route;
import org.restlet.routing.Router;
import org.restlet.routing.TemplateRoute;
import org.restlet.routing.VirtualHost;

public class Introspector
extends IntrospectionUtils {
    protected static Logger LOGGER = Logger.getLogger(Introspector.class.getName());
    private Definition definition;

    private static Application getApplication(String className) {
        Application result = null;
        if (className == null) {
            return result;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            if (Application.class.isAssignableFrom(clazz)) {
                result = (Application)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                LOGGER.log(Level.SEVERE, className + " does not seem to be a valid subclass of " + Application.class.getName() + " class.");
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Cannot locate the definition source.", e);
        }
        catch (InstantiationException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the application class.", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the application class.", e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Check that the application class has an empty constructor.", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the application class.", e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.SEVERE, "Check that the application class has an empty constructor.", e);
        }
        catch (SecurityException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the application class.", e);
        }
        return result;
    }

    protected static ApplicationInfo getApplicationInfo(Application application, Reference baseRef) {
        ApplicationInfo applicationInfo = new ApplicationInfo();
        if (application.getName() != null && !application.getName().isEmpty()) {
            DocumentationInfo doc = null;
            if (applicationInfo.getDocumentations().isEmpty()) {
                doc = new DocumentationInfo();
                applicationInfo.getDocumentations().add(doc);
            } else {
                doc = applicationInfo.getDocumentations().get(0);
            }
            applicationInfo.setName(application.getName());
            doc.setTitle(application.getName());
        }
        applicationInfo.getResources().setBaseRef(baseRef);
        applicationInfo.getResources().setResources(Introspector.getResourceInfos(applicationInfo, Introspector.getNextRouter(application.getInboundRoot()), "/"));
        return applicationInfo;
    }

    private static Component getComponent(String className) {
        Component result = null;
        if (className == null) {
            return result;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            if (Component.class.isAssignableFrom(clazz)) {
                result = (Component)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                LOGGER.log(Level.SEVERE, className + " does not seem to a valid subclass of " + Component.class.getName() + " class.");
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Cannot locate the component class.", e);
        }
        catch (InstantiationException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the component class.", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the component class.", e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Check that the component class has an empty constructor.", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the component class.", e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.SEVERE, "Check that the component class has an empty constructor.", e);
        }
        catch (SecurityException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the component class.", e);
        }
        return result;
    }

    private static Application getNextApplication(Restlet current) {
        Application result;
        block2: {
            Route route;
            block3: {
                block1: {
                    result = null;
                    if (!(current instanceof Application)) break block1;
                    result = (Application)current;
                    break block2;
                }
                if (!(current instanceof org.restlet.routing.Filter)) break block3;
                result = Introspector.getNextApplication(((org.restlet.routing.Filter)current).getNext());
                break block2;
            }
            if (!(current instanceof Router)) break block2;
            Router router = (Router)current;
            Iterator i$ = router.getRoutes().iterator();
            while (i$.hasNext() && (result = Introspector.getNextApplication((route = (Route)i$.next()).getNext())) == null) {
            }
        }
        return result;
    }

    private static Router getNextRouter(Restlet current) {
        Router result = null;
        if (current instanceof Router) {
            result = (Router)current;
        } else if (current instanceof org.restlet.routing.Filter) {
            result = Introspector.getNextRouter(((org.restlet.routing.Filter)current).getNext());
        }
        return result;
    }

    private static String getParameter(String[] args, int index) {
        if (index >= args.length) {
            return null;
        }
        String value = args[index];
        if ("-s".equals(value) || "-u".equals(value) || "-p".equals(value) || "-d".equals(value) || "-c".equals(value)) {
            value = null;
        }
        return value;
    }

    private static ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, org.restlet.routing.Filter filter, String path) {
        return Introspector.getResourceInfo(applicationInfo, filter.getNext(), path);
    }

    private static ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Finder finder, String path) {
        ResourceInfo result = null;
        Finder resource = null;
        if (finder instanceof Directory) {
            resource = finder;
        } else {
            ServerResource sr = finder.find(null, null);
            if (sr != null) {
                Request request = new Request();
                Response response = new Response(request);
                sr.setRequest(request);
                sr.setResponse(response);
                sr.updateAllowedMethods();
                resource = sr;
            }
        }
        if (resource != null) {
            result = new ResourceInfo();
            ResourceInfo.describe(applicationInfo, result, resource, path);
        }
        return result;
    }

    private static ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Restlet restlet, String path) {
        ResourceInfo result = null;
        if (restlet instanceof Finder) {
            result = Introspector.getResourceInfo(applicationInfo, (Finder)restlet, path);
        } else if (restlet instanceof Router) {
            result = new ResourceInfo();
            result.setPath(path);
            result.setChildResources(Introspector.getResourceInfos(applicationInfo, (Router)restlet, path));
        } else if (restlet instanceof org.restlet.routing.Filter) {
            result = Introspector.getResourceInfo(applicationInfo, (org.restlet.routing.Filter)restlet, path);
        }
        return result;
    }

    private static ResourceInfo getResourceInfo(ApplicationInfo applicationInfo, Route route, String basePath) {
        ResourceInfo result = null;
        if (route instanceof TemplateRoute) {
            TemplateRoute templateRoute = (TemplateRoute)route;
            String path = templateRoute.getTemplate().getPattern();
            path = path.startsWith("/") && basePath.endsWith("/") ? basePath + path.substring(1) : basePath + path;
            result = Introspector.getResourceInfo(applicationInfo, route.getNext(), path);
        }
        return result;
    }

    private static List<ResourceInfo> getResourceInfos(ApplicationInfo applicationInfo, Router router, String path) {
        ArrayList<ResourceInfo> result = new ArrayList<ResourceInfo>();
        if (router != null) {
            ResourceInfo resourceInfo;
            for (Route route : router.getRoutes()) {
                ResourceInfo resourceInfo2 = Introspector.getResourceInfo(applicationInfo, route, path);
                if (resourceInfo2 == null) continue;
                result.add(resourceInfo2);
            }
            if (router.getDefaultRoute() != null && (resourceInfo = Introspector.getResourceInfo(applicationInfo, router.getDefaultRoute(), path)) != null) {
                result.add(resourceInfo);
            }
        }
        return result;
    }

    public static void main(String[] args) throws TranslationException {
        IntrospectionUtils i;
        Engine.register();
        String ulogin = null;
        String upwd = null;
        String serviceUrl = null;
        String defSource = null;
        String compName = null;
        String definitionId = null;
        String language = null;
        LOGGER.fine("Get parameters");
        for (int i2 = 0; i2 < args.length; ++i2) {
            if ("-h".equals(args[i2])) {
                Introspector.printHelp();
                System.exit(0);
                continue;
            }
            if ("-u".equals(args[i2]) || "--username".equals(args[i2])) {
                ulogin = Introspector.getParameter(args, ++i2);
                continue;
            }
            if ("-p".equals(args[i2]) || "--password".equals(args[i2])) {
                upwd = Introspector.getParameter(args, ++i2);
                continue;
            }
            if ("-s".equals(args[i2]) || "--service".equals(args[i2])) {
                serviceUrl = Introspector.getParameter(args, ++i2);
                continue;
            }
            if ("-c".equals(args[i2]) || "--component".equals(args[i2])) {
                compName = Introspector.getParameter(args, ++i2);
                continue;
            }
            if ("-d".equals(args[i2]) || "--definition".equals(args[i2])) {
                definitionId = Introspector.getParameter(args, ++i2);
                continue;
            }
            if ("-l".equals(args[i2]) || "--language".equals(args[i2])) {
                language = Introspector.getParameter(args, ++i2).toLowerCase();
                continue;
            }
            if ("-v".equals(args[i2]) || "--verbose".equals(args[i2])) {
                Engine.setLogLevel((Level)Level.FINE);
                continue;
            }
            defSource = args[i2];
        }
        Engine.getLogger((String)"").getHandlers()[0].setFilter(new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return record.getLoggerName().startsWith("org.restlet.ext.apispark");
            }
        });
        LOGGER.fine("Check parameters");
        if (Introspector.isEmpty(serviceUrl)) {
            serviceUrl = "https://apispark.com/";
        }
        if (!serviceUrl.endsWith("/")) {
            serviceUrl = serviceUrl + "/";
        }
        if (Introspector.isEmpty(ulogin) || Introspector.isEmpty(upwd) || Introspector.isEmpty(defSource)) {
            Introspector.printHelp();
            System.exit(1);
        }
        Application application = null;
        Component component = null;
        Definition definition = null;
        javax.ws.rs.core.Application a = null;
        if (language == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(defSource);
                if (Application.class.isAssignableFrom(clazz)) {
                    application = Introspector.getApplication(defSource);
                    component = Introspector.getComponent(compName);
                } else if (clazz != null) {
                    a = JaxrsIntrospector.getApplication(defSource);
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.SEVERE, "Cannot locate the application class.", e);
            }
        }
        if (application != null) {
            LOGGER.info("Instantiate introspector");
            i = new Introspector(component, application);
            LOGGER.info("Generate documentation");
            definition = ((Introspector)i).getDefinition();
        } else if (a != null) {
            LOGGER.fine("Instantiate introspector");
            i = new JaxrsIntrospector(a);
            LOGGER.info("Generate documentation");
            definition = ((JaxrsIntrospector)i).getDefinition();
        } else if ("swagger".equals(language)) {
            definition = SwaggerUtils.getDefinition(defSource, ulogin, upwd);
        }
        if (definition != null) {
            Introspector.sendDefinition(definition, definitionId, ulogin, upwd, serviceUrl, LOGGER);
        } else {
            LOGGER.severe("Please provide a valid application class name or definition URL.");
        }
    }

    private static void printHelp() {
        PrintStream o = System.out;
        o.println("SYNOPSIS");
        Introspector.printSynopsis(o, Introspector.class, "[options] APPLICATION");
        Introspector.printSynopsis(o, Introspector.class, "-l swagger [options] SWAGGER DEFINITION URL/PATH");
        o.println("DESCRIPTION");
        Introspector.printSentence(o, "Publish to the APISpark platform the description of your Web API, represented by APPLICATION,", "the full name of your Restlet application class or by the swagger definition available on the ", "URL/PATH");
        Introspector.printSentence(o, "If the whole process is successfull, it displays the url of the corresponding documentation.");
        o.println("OPTIONS");
        Introspector.printOption(o, "-h, --help", "Prints this help.");
        Introspector.printOption(o, "-u, --username", "The mandatory APISpark user name.");
        Introspector.printOption(o, "-p, --password", "The mandatory APISpark user secret key.");
        Introspector.printOption(o, "-c, --component", "The optional full name of your Restlet Component class.", "This allows to collect some other data, such as the endpoint.");
        Introspector.printOption(o, "-d, --definition", "The optional identifier of an existing definition hosted by APISpark you want to update with this new documentation.");
        Introspector.printOption(o, "-l, --language", "The optional name of the description language of the definition you want to upload. Possible value: swagger");
        Introspector.printOption(o, "-v, --verbose", "The optional parameter switching the process to a verbose mode");
    }

    public Introspector(Application application, boolean verbose) {
        this(null, application);
    }

    public Introspector(Component component, Application application) {
        this.definition = IntrospectionTranslator.toDefinition(Introspector.getApplicationInfo(application, null), LOGGER);
        if (component != null && this.definition != null) {
            LOGGER.fine("Look for the endpoint.");
            String endpoint = null;
            endpoint = this.getEndpoint(component.getDefaultHost(), application);
            for (int i = 0; endpoint == null && i < component.getHosts().size(); ++i) {
                VirtualHost virtualHost = (VirtualHost)component.getHosts().get(i);
                endpoint = this.getEndpoint(virtualHost, application);
            }
            this.definition.setEndpoint(endpoint);
        }
    }

    private Definition getDefinition() {
        return this.definition;
    }

    private String getEndpoint(VirtualHost virtualHost, Application application) {
        String result = null;
        for (Route route : virtualHost.getRoutes()) {
            Application app;
            if (route.getNext() == null || (app = Introspector.getNextApplication(route.getNext())) == null || !application.getClass().equals(app.getClass())) continue;
            String hostDomain = null;
            if (virtualHost.getHostDomain() != null && !".*".equals(virtualHost.getHostDomain())) {
                hostDomain = virtualHost.getHostDomain().contains("|") ? virtualHost.getHostDomain().split("|")[0] : virtualHost.getHostDomain();
            }
            if (hostDomain == null) continue;
            Protocol scheme = null;
            if (!".*".equals(virtualHost.getHostScheme())) {
                scheme = Protocol.valueOf((String)virtualHost.getHostScheme());
            }
            if (scheme == null) {
                scheme = Protocol.HTTP;
            }
            Reference ref = new Reference();
            ref.setProtocol(scheme);
            ref.setHostDomain(hostDomain);
            if (route instanceof TemplateRoute) {
                ref.addSegment(((TemplateRoute)route).getTemplate().getPattern());
            }
            try {
                ref.setHostPort(Integer.valueOf(Integer.parseInt(virtualHost.getHostPort())));
            }
            catch (Exception e) {
                // empty catch block
            }
            result = ref.toString();
        }
        return result;
    }
}

