/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark;

import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.apispark.internal.conversion.IntrospectionTranslator;
import org.restlet.ext.apispark.internal.info.ApplicationInfo;
import org.restlet.ext.apispark.internal.info.MethodInfo;
import org.restlet.ext.apispark.internal.info.ParameterInfo;
import org.restlet.ext.apispark.internal.info.ParameterStyle;
import org.restlet.ext.apispark.internal.info.RepresentationInfo;
import org.restlet.ext.apispark.internal.info.RequestInfo;
import org.restlet.ext.apispark.internal.info.ResourceInfo;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.reflect.ReflectUtils;
import org.restlet.ext.apispark.internal.utils.IntrospectionUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.routing.Template;

public class JaxrsIntrospector
extends IntrospectionUtils {
    protected static Logger LOGGER = Context.getCurrentLogger();
    private Definition definition;

    private static void addRepresentation(MethodInfo method, FormParam formParam) {
        if (formParam != null) {
            RepresentationInfo ri = null;
            for (RepresentationInfo r : method.getRequest().getRepresentations()) {
                if (!r.getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM)) continue;
                ri = r;
                break;
            }
            if (ri == null) {
                ri = new RepresentationInfo();
                ri.setIdentifier(method.getMethod().getName() + "Form");
                ri.setName(method.getMethod().getName());
                ri.setMediaType(MediaType.APPLICATION_WWW_FORM);
                method.getRequest().getRepresentations().add(ri);
            }
            ParameterInfo pi = new ParameterInfo(formParam.value(), ParameterStyle.PLAIN, "body parameter: " + formParam.value());
            method.getParameters().add(pi);
        }
    }

    private static String cleanPath(String path) {
        if (path != null) {
            StringBuilder sb = new StringBuilder();
            boolean inVariable = false;
            boolean endVariable = false;
            StringBuilder varBuffer = null;
            for (int i = 0; i < path.length(); ++i) {
                char next = path.charAt(i);
                if (inVariable) {
                    if (next == '}') {
                        if (varBuffer.length() == 0) {
                            LOGGER.warning("Empty pattern variables are not allowed : " + path);
                        } else {
                            sb.append(varBuffer.toString());
                            varBuffer = new StringBuilder();
                        }
                        endVariable = false;
                        inVariable = false;
                        sb.append(next);
                        continue;
                    }
                    if (endVariable) continue;
                    if (Reference.isUnreserved((int)next)) {
                        varBuffer.append(next);
                        continue;
                    }
                    if (next != ':') continue;
                    endVariable = true;
                    continue;
                }
                sb.append(next);
                if (next == '{') {
                    inVariable = true;
                    varBuffer = new StringBuilder();
                    continue;
                }
                if (next != '}') continue;
                LOGGER.warning("An invalid character was detected inside a pattern variable : " + path);
            }
            return sb.toString();
        }
        return null;
    }

    protected static javax.ws.rs.core.Application getApplication(String className) {
        javax.ws.rs.core.Application result = null;
        if (className == null) {
            return result;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
            if (javax.ws.rs.core.Application.class.isAssignableFrom(clazz)) {
                result = (javax.ws.rs.core.Application)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                LOGGER.log(Level.SEVERE, className + " does not seem to be a valid subclass of " + Application.class.getName() + " class.");
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Cannot locate the application class.", e);
        }
        catch (InstantiationException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the application class.", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the application class.", e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Check that the application class has an empty constructor.", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the application class.", e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.SEVERE, "Check that the application class has an empty constructor.", e);
        }
        catch (SecurityException e) {
            LOGGER.log(Level.SEVERE, "Cannot instantiate the application class.", e);
        }
        return result;
    }

    protected static ApplicationInfo getApplicationInfo(javax.ws.rs.core.Application application, Reference baseRef) {
        ApplicationInfo applicationInfo = new ApplicationInfo();
        for (Class clazz : application.getClasses()) {
            JaxrsIntrospector.scan(clazz, applicationInfo, baseRef);
        }
        for (Object singleton : application.getSingletons()) {
            if (singleton == null) continue;
            JaxrsIntrospector.scan(singleton.getClass(), applicationInfo, baseRef);
        }
        applicationInfo.getResources().setBaseRef(baseRef);
        return applicationInfo;
    }

    private static String getParameter(String[] args, int index) {
        if (index >= args.length) {
            return null;
        }
        String value = args[index];
        if ("-s".equals(value) || "-u".equals(value) || "-p".equals(value) || "-d".equals(value) || "-c".equals(value)) {
            value = null;
        }
        return value;
    }

    private static String getPath(Path rootPath, Path relativePath) {
        return JaxrsIntrospector.getPath(rootPath != null ? rootPath.value() : null, relativePath != null ? relativePath.value() : null);
    }

    private static String getPath(String rootPath, String relativePath) {
        String result = null;
        if (rootPath == null) {
            rootPath = "/";
        } else if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        result = relativePath == null ? rootPath : (rootPath.endsWith("/") ? (relativePath.startsWith("/") ? rootPath + relativePath.substring(1) : rootPath + relativePath) : (relativePath.startsWith("/") ? rootPath + relativePath : rootPath + "/" + relativePath));
        return result;
    }

    public static void main(String[] args) {
        String ulogin = null;
        String upwd = null;
        String serviceUrl = null;
        String appName = null;
        String definitionId = null;
        LOGGER.fine("Get parameters");
        for (int i = 0; i < args.length; ++i) {
            if ("-h".equals(args[i])) {
                JaxrsIntrospector.printHelp();
                System.exit(0);
                continue;
            }
            if ("-u".equals(args[i])) {
                ulogin = JaxrsIntrospector.getParameter(args, ++i);
                continue;
            }
            if ("-p".equals(args[i])) {
                upwd = JaxrsIntrospector.getParameter(args, ++i);
                continue;
            }
            if ("-s".equals(args[i])) {
                serviceUrl = JaxrsIntrospector.getParameter(args, ++i);
                continue;
            }
            if ("-d".equals(args[i])) {
                definitionId = JaxrsIntrospector.getParameter(args, ++i);
                continue;
            }
            appName = args[i];
        }
        LOGGER.fine("Check parameters");
        if (JaxrsIntrospector.isEmpty(serviceUrl)) {
            serviceUrl = "https://apispark.com/";
        }
        if (!serviceUrl.endsWith("/")) {
            serviceUrl = serviceUrl + "/";
        }
        if (JaxrsIntrospector.isEmpty(ulogin) || JaxrsIntrospector.isEmpty(upwd) || JaxrsIntrospector.isEmpty(appName)) {
            JaxrsIntrospector.printHelp();
            System.exit(1);
        }
        javax.ws.rs.core.Application application = JaxrsIntrospector.getApplication(appName);
        Definition definition = null;
        if (application != null) {
            LOGGER.fine("Instantiate introspector");
            JaxrsIntrospector i = new JaxrsIntrospector(application);
            LOGGER.info("Generate documentation");
            definition = i.getDefinition();
        }
        if (definition != null) {
            JaxrsIntrospector.sendDefinition(definition, definitionId, ulogin, upwd, serviceUrl, LOGGER);
        } else {
            LOGGER.severe("Please provide a valid application class name.");
        }
    }

    private static void printHelp() {
        PrintStream o = System.out;
        o.println("SYNOPSIS");
        JaxrsIntrospector.printSynopsis(o, JaxrsIntrospector.class, "[options] APPLICATION");
        o.println("DESCRIPTION");
        JaxrsIntrospector.printSentence(o, "Publish to the APISpark platform the description of your Web API, represented by APPLICATION,", "the full name of your Restlet application class.");
        JaxrsIntrospector.printSentence(o, "If the whole process is successfull, it displays the url of the corresponding documentation.");
        o.println("OPTIONS");
        JaxrsIntrospector.printOption(o, "-h", "Prints this help.");
        JaxrsIntrospector.printOption(o, "-u", "The mandatory APISpark user name.");
        JaxrsIntrospector.printOption(o, "-p", "The mandatory APISpark user secret key.");
        JaxrsIntrospector.printOption(o, "-s", "The optional APISpark platform URL (by default https://apispark.com).");
        JaxrsIntrospector.printOption(o, "-c", "The optional full name of your Restlet Component class.", "This allows to collect some other data, such as the endpoint.");
        JaxrsIntrospector.printOption(o, "-d", "The optional identifier of an existing definition hosted by APISpark you want to update with this new documentation.");
        o.println("LOGGING");
        JaxrsIntrospector.printSentence(o, "You can get a detailled log of the process using the JDK's API.", "See the official documentation: http://docs.oracle.com/javase/7/docs/technotes/guides/logging/overview.html", "Here is the name of the used Logger: " + JaxrsIntrospector.class.getName());
    }

    private static void scan(Annotation[] annotations, Class<?> parameterClass, Type parameterType, ApplicationInfo info, ResourceInfo resource, MethodInfo method, Consumes consumes) {
        boolean valueComputed = false;
        for (Annotation annotation : annotations) {
            String value;
            if (annotation instanceof CookieParam) {
                valueComputed = true;
                value = ((CookieParam)annotation).value();
                ParameterInfo pi = new ParameterInfo(value, ParameterStyle.COOKIE, "Cookie parameter: " + value);
                method.getRequest().getParameters().add(pi);
                continue;
            }
            if (annotation instanceof DefaultValue || annotation instanceof Encoded) continue;
            if (annotation instanceof FormParam) {
                valueComputed = true;
                JaxrsIntrospector.addRepresentation(method, (FormParam)annotation);
                continue;
            }
            if (annotation instanceof HeaderParam) {
                valueComputed = true;
                value = ((HeaderParam)annotation).value();
                ParameterInfo pi = new ParameterInfo(value, ParameterStyle.HEADER, "header parameter: " + value);
                method.getParameters().add(pi);
                continue;
            }
            if (annotation instanceof MatrixParam) {
                valueComputed = true;
                value = ((MatrixParam)annotation).value();
                ParameterInfo pi = new ParameterInfo(value, ParameterStyle.MATRIX, "matrix parameter: " + value);
                method.getParameters().add(pi);
                continue;
            }
            if (annotation instanceof PathParam) {
                valueComputed = true;
                value = ((PathParam)annotation).value();
                boolean found = false;
                for (ParameterInfo p : resource.getParameters()) {
                    if (!p.getName().equals(value)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                ParameterInfo pi = new ParameterInfo(value, ParameterStyle.TEMPLATE, "Path parameter: " + value);
                resource.getParameters().add(pi);
                continue;
            }
            if (annotation instanceof QueryParam) {
                valueComputed = true;
                value = ((QueryParam)annotation).value();
                ParameterInfo pi = new ParameterInfo(value, ParameterStyle.QUERY, "Query parameter: " + value);
                method.getParameters().add(pi);
                continue;
            }
            if (!(annotation instanceof javax.ws.rs.core.Context)) continue;
            valueComputed = true;
            javax.ws.rs.core.Context context = (javax.ws.rs.core.Context)annotation;
        }
        if (!valueComputed && parameterClass != null && !Void.class.equals(parameterClass)) {
            String[] mediaTypes = null;
            mediaTypes = consumes == null || consumes.value() == null || consumes.value().length == 0 ? new String[]{MediaType.APPLICATION_ALL.getName()} : consumes.value();
            for (String consume : mediaTypes) {
                Variant variant = new Variant(MediaType.valueOf((String)consume));
                RepresentationInfo representationInfo = null;
                representationInfo = RepresentationInfo.describe(method, parameterClass, parameterType, variant);
                if (method.getRequest() == null) {
                    method.setRequest(new RequestInfo());
                }
                method.getRequest().getRepresentations().add(representationInfo);
            }
        }
    }

    private static void scan(Class<?> clazz, ApplicationInfo info, Reference baseRef) {
        Method[] methods;
        info.getResources().setBaseRef(baseRef);
        ArrayList<CookieParam> cookieParams = new ArrayList<CookieParam>();
        ArrayList<FormParam> formParams = new ArrayList<FormParam>();
        ArrayList<HeaderParam> headerParams = new ArrayList<HeaderParam>();
        ArrayList<MatrixParam> matrixParams = new ArrayList<MatrixParam>();
        ArrayList<PathParam> pathParams = new ArrayList<PathParam>();
        ArrayList<QueryParam> queryParams = new ArrayList<QueryParam>();
        ArrayList<javax.ws.rs.core.Context> contextList = new ArrayList<javax.ws.rs.core.Context>();
        Consumes c = clazz.getAnnotation(Consumes.class);
        Path path = clazz.getAnnotation(Path.class);
        Produces p = clazz.getAnnotation(Produces.class);
        Field[] fields = ReflectUtils.getAllDeclaredFields(clazz);
        if (fields != null) {
            for (Field field : fields) {
                JaxrsIntrospector.scan(field, cookieParams, formParams, headerParams, matrixParams, pathParams, queryParams, contextList);
            }
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            JaxrsIntrospector.scan(method, info, path, c, p, cookieParams, formParams, headerParams, matrixParams, pathParams, queryParams, contextList);
        }
    }

    private static void scan(Field field, List<CookieParam> cookieParams, List<FormParam> formParams, List<HeaderParam> headerParams, List<MatrixParam> matrixParams, List<PathParam> pathParams, List<QueryParam> queryParams, List<javax.ws.rs.core.Context> contextList) {
        QueryParam queryParam;
        PathParam pathParam;
        MatrixParam matrixParam;
        HeaderParam headerParam;
        FormParam formParam;
        CookieParam cookieParam = field.getAnnotation(CookieParam.class);
        if (cookieParam != null) {
            cookieParams.add(cookieParam);
        }
        if ((formParam = field.getAnnotation(FormParam.class)) != null) {
            formParams.add(formParam);
        }
        if ((headerParam = field.getAnnotation(HeaderParam.class)) != null) {
            headerParams.add(headerParam);
        }
        if ((matrixParam = field.getAnnotation(MatrixParam.class)) != null) {
            matrixParams.add(matrixParam);
        }
        if ((pathParam = field.getAnnotation(PathParam.class)) != null) {
            pathParams.add(pathParam);
        }
        if ((queryParam = field.getAnnotation(QueryParam.class)) != null) {
            queryParams.add(queryParam);
        }
        javax.ws.rs.core.Context context = field.getAnnotation(javax.ws.rs.core.Context.class);
    }

    private static void scan(Method method, ApplicationInfo info, Path cPath, Consumes cConsumes, Produces cProduces, List<CookieParam> cookieParams, List<FormParam> formParams, List<HeaderParam> headerParams, List<MatrixParam> matrixParams, List<PathParam> pathParams, List<QueryParam> queryParams, List<javax.ws.rs.core.Context> contextList) {
        Consumes consumes;
        QueryParam queryParam;
        MatrixParam matrixParam;
        ParameterInfo pi;
        MethodInfo mi = new MethodInfo();
        for (FormParam formParam : formParams) {
            JaxrsIntrospector.addRepresentation(mi, formParam);
        }
        Path path = method.getAnnotation(Path.class);
        String fullPath = JaxrsIntrospector.getPath(cPath, path);
        String cleanPath = JaxrsIntrospector.cleanPath(fullPath);
        ResourceInfo resource = null;
        for (ResourceInfo ri : info.getResources().getResources()) {
            if (!cleanPath.equals(ri.getPath())) continue;
            resource = ri;
            break;
        }
        if (resource == null) {
            resource = new ResourceInfo();
            resource.setIdentifier(cleanPath);
            resource.setPath(cleanPath);
            info.getResources().getResources().add(resource);
        }
        resource.getMethods().add(mi);
        PathParam pathParam = method.getAnnotation(PathParam.class);
        if (pathParam != null) {
            pathParams.add(pathParam);
            ParameterInfo pi2 = new ParameterInfo(pathParam.value(), ParameterStyle.TEMPLATE, "Path parameter: " + pathParam.value());
            pi2.setRequired(true);
            resource.getParameters().add(pi2);
        } else {
            Template template = new Template(cleanPath);
            for (String var : template.getVariableNames()) {
                boolean found = false;
                for (ParameterInfo pi3 : resource.getParameters()) {
                    if (!pi3.getStyle().equals((Object)ParameterStyle.TEMPLATE) || !var.equals(pi3.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                pi = new ParameterInfo(var, ParameterStyle.TEMPLATE, "Path parameter: " + var);
                pi.setRequired(true);
                resource.getParameters().add(pi);
            }
        }
        CookieParam cookieParam = method.getAnnotation(CookieParam.class);
        if (cookieParam != null) {
            ParameterInfo pi4 = new ParameterInfo(cookieParam.value(), ParameterStyle.COOKIE, "Cookie parameter: " + cookieParam.value());
            mi.getParameters().add(pi4);
        }
        FormParam formParam = method.getAnnotation(FormParam.class);
        JaxrsIntrospector.addRepresentation(mi, formParam);
        HeaderParam headerParam = method.getAnnotation(HeaderParam.class);
        if (headerParam != null) {
            ParameterInfo pi5 = new ParameterInfo(headerParam.value(), ParameterStyle.HEADER, "Header parameter: " + cookieParam.value());
            mi.getParameters().add(pi5);
        }
        if ((matrixParam = method.getAnnotation(MatrixParam.class)) != null) {
            pi = new ParameterInfo(matrixParam.value(), ParameterStyle.MATRIX, "Matrix parameter: " + cookieParam.value());
            mi.getParameters().add(pi);
        }
        if ((queryParam = method.getAnnotation(QueryParam.class)) != null) {
            ParameterInfo pi3;
            pi3 = new ParameterInfo(queryParam.value(), ParameterStyle.QUERY, "Query parameter: " + cookieParam.value());
            mi.getParameters().add(pi3);
        }
        DELETE delete = method.getAnnotation(DELETE.class);
        GET get = method.getAnnotation(GET.class);
        HEAD head = method.getAnnotation(HEAD.class);
        OPTIONS options = method.getAnnotation(OPTIONS.class);
        POST post = method.getAnnotation(POST.class);
        PUT put = method.getAnnotation(PUT.class);
        HttpMethod httpMethod = method.getAnnotation(HttpMethod.class);
        if (delete != null) {
            mi.setMethod(org.restlet.data.Method.DELETE);
        } else if (get != null) {
            mi.setMethod(org.restlet.data.Method.GET);
        } else if (head != null) {
            mi.setMethod(org.restlet.data.Method.HEAD);
        } else if (httpMethod != null) {
            mi.setMethod(org.restlet.data.Method.valueOf((String)httpMethod.value()));
        } else if (options != null) {
            mi.setMethod(org.restlet.data.Method.OPTIONS);
        } else if (post != null) {
            mi.setMethod(org.restlet.data.Method.POST);
        } else if (put != null) {
            mi.setMethod(org.restlet.data.Method.PUT);
        }
        Produces produces = method.getAnnotation(Produces.class);
        if (produces == null) {
            produces = cProduces;
        }
        Class<?> outputClass = method.getReturnType();
        if (produces != null && outputClass != null && !Void.class.equals(outputClass)) {
            for (String produce : produces.value()) {
                Variant variant = new Variant(MediaType.valueOf((String)produce));
                RepresentationInfo representationInfo = null;
                if (Response.class.isAssignableFrom(outputClass)) {
                    representationInfo = new RepresentationInfo(variant);
                    representationInfo.setType(Representation.class);
                    representationInfo.setIdentifier(representationInfo.getType().getCanonicalName());
                    representationInfo.setName(representationInfo.getType().getSimpleName());
                    representationInfo.setRaw(true);
                } else {
                    representationInfo = RepresentationInfo.describe(mi, outputClass, method.getGenericReturnType(), variant);
                }
                mi.getResponse().getRepresentations().add(representationInfo);
            }
        }
        if ((consumes = method.getAnnotation(Consumes.class)) == null) {
            consumes = cConsumes;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int i = 0;
        for (Annotation[] annotations : parameterAnnotations) {
            Class<?> parameterType = parameterTypes[i];
            JaxrsIntrospector.scan(annotations, parameterType, method.getGenericParameterTypes()[i], info, resource, mi, consumes);
            ++i;
        }
        if (mi.getResponse().getStatuses().isEmpty()) {
            mi.getResponse().getStatuses().add(Status.SUCCESS_OK);
            mi.getResponse().setDocumentation("Success");
        }
    }

    private static void scanAnnotation() {
    }

    private static void scanConstructor() {
    }

    public JaxrsIntrospector(javax.ws.rs.core.Application application) {
        this.definition = IntrospectionTranslator.toDefinition(JaxrsIntrospector.getApplicationInfo(application, null), LOGGER);
        if (this.definition != null) {
            LOGGER.fine("Look for the endpoint.");
            String endpoint = null;
            ApplicationPath ap = application.getClass().getAnnotation(ApplicationPath.class);
            if (ap != null) {
                endpoint = ap.value();
            }
            this.definition.setEndpoint(endpoint);
        }
    }

    protected Definition getDefinition() {
        return this.definition;
    }
}

