/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.conversion;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.apispark.internal.conversion.TranslationException;
import org.restlet.ext.apispark.internal.model.Contract;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Entity;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.PathVariable;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.QueryParameter;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Resource;
import org.restlet.ext.apispark.internal.model.Response;
import org.restlet.ext.apispark.internal.model.swagger.ApiDeclaration;
import org.restlet.ext.apispark.internal.model.swagger.ApiInfo;
import org.restlet.ext.apispark.internal.model.swagger.ItemsDeclaration;
import org.restlet.ext.apispark.internal.model.swagger.ModelDeclaration;
import org.restlet.ext.apispark.internal.model.swagger.ResourceDeclaration;
import org.restlet.ext.apispark.internal.model.swagger.ResourceListing;
import org.restlet.ext.apispark.internal.model.swagger.ResourceOperationDeclaration;
import org.restlet.ext.apispark.internal.model.swagger.ResourceOperationParameterDeclaration;
import org.restlet.ext.apispark.internal.model.swagger.ResponseMessageDeclaration;
import org.restlet.ext.apispark.internal.model.swagger.TypePropertyDeclaration;
import org.restlet.ext.apispark.internal.reflect.ReflectUtils;

public abstract class SwaggerTranslator {
    protected static Logger LOGGER = Logger.getLogger(SwaggerTranslator.class.getName());
    private static final String SWAGGER_VERSION = "1.2";

    public static ApiDeclaration getApiDeclaration(String category, Definition definition) {
        ApiDeclaration result = new ApiDeclaration();
        result.setApiVersion(definition.getVersion());
        result.setBasePath(definition.getEndpoint());
        result.setInfo(new ApiInfo());
        result.setSwaggerVersion(SWAGGER_VERSION);
        result.setResourcePath("/" + category);
        HashSet<String> usedModels = new HashSet<String>();
        for (Resource resource : definition.getContract().getResources()) {
            if (!resource.getResourcePath().startsWith("/" + category)) continue;
            ResourceDeclaration rd = new ResourceDeclaration();
            rd.setPath(resource.getResourcePath());
            rd.setDescription(resource.getDescription());
            for (Operation operation : resource.getOperations()) {
                Entity outRepr;
                ResourceOperationParameterDeclaration ropd;
                ResourceOperationDeclaration rod = new ResourceOperationDeclaration();
                rod.setMethod(operation.getMethod());
                rod.setSummary(operation.getDescription());
                rod.setNickname(operation.getName());
                rod.setProduces(operation.getProduces());
                rod.setConsumes(operation.getConsumes());
                for (PathVariable pv : resource.getPathVariables()) {
                    ropd = new ResourceOperationParameterDeclaration();
                    ropd.setParamType("path");
                    ropd.setType(SwaggerTranslator.toSwaggerType(pv.getType()));
                    ropd.setRequired(true);
                    ropd.setName(pv.getName());
                    ropd.setAllowMultiple(false);
                    ropd.setDescription(pv.getDescription());
                    rod.getParameters().add(ropd);
                }
                Entity inRepr = operation.getInRepresentation();
                if (inRepr != null) {
                    ropd = new ResourceOperationParameterDeclaration();
                    ropd.setParamType("body");
                    ropd.setRequired(true);
                    if ("Representation".equals(inRepr.getType())) {
                        ropd.setType("File");
                    } else {
                        ropd.setType(SwaggerTranslator.toSwaggerType(inRepr.getType()));
                    }
                    if (inRepr.getType() != null) {
                        usedModels.add(inRepr.getType());
                    }
                    rod.getParameters().add(ropd);
                }
                if ((outRepr = operation.getOutRepresentation()) != null && outRepr.getType() != null) {
                    if (outRepr.isArray()) {
                        rod.setType("array");
                        if (SwaggerTranslator.isPrimitiveType(outRepr.getType())) {
                            rod.getItems().setType(SwaggerTranslator.toSwaggerType(outRepr.getType()));
                        } else {
                            rod.getItems().setRef(outRepr.getType());
                        }
                    } else {
                        rod.setType(SwaggerTranslator.toSwaggerType(outRepr.getType()));
                    }
                    usedModels.add(outRepr.getType());
                } else {
                    rod.setType("void");
                }
                for (QueryParameter qp : operation.getQueryParameters()) {
                    ropd = new ResourceOperationParameterDeclaration();
                    ropd.setParamType("query");
                    ropd.setType(SwaggerTranslator.toSwaggerType(qp.getType()));
                    ropd.setName(qp.getName());
                    ropd.setAllowMultiple(true);
                    ropd.setDescription(qp.getDescription());
                    ropd.setEnum_(qp.getEnumeration());
                    ropd.setDefaultValue(qp.getDefaultValue());
                    rod.getParameters().add(ropd);
                }
                for (Response response : operation.getResponses()) {
                    if (Status.isSuccess((int)response.getCode())) continue;
                    ResponseMessageDeclaration rmd = new ResponseMessageDeclaration();
                    rmd.setCode(response.getCode());
                    rmd.setMessage(response.getMessage());
                    if (response.getEntity() != null) {
                        rmd.setResponseModel(response.getEntity().getType());
                    }
                    rod.getResponseMessages().add(rmd);
                }
                rd.getOperations().add(rod);
            }
            result.getApis().add(rd);
        }
        result.setModels(new TreeMap<String, ModelDeclaration>());
        Iterator iterator = usedModels.iterator();
        while (iterator.hasNext()) {
            String model = (String)iterator.next();
            Representation repr = SwaggerTranslator.getRepresentationByName(definition.getContract(), model);
            if (repr == null || SwaggerTranslator.isPrimitiveType(model)) continue;
            ModelDeclaration md = new ModelDeclaration();
            md.setId(model);
            md.setDescription(repr.getDescription());
            for (Property prop : repr.getProperties()) {
                if (prop.getMinOccurs() > 0) {
                    md.getRequired().add(prop.getName());
                }
                if (!SwaggerTranslator.isPrimitiveType(prop.getType()) && !usedModels.contains(prop.getType())) {
                    usedModels.add(prop.getType());
                    iterator = usedModels.iterator();
                }
                TypePropertyDeclaration tpd = new TypePropertyDeclaration();
                tpd.setDescription(prop.getDescription());
                tpd.setEnum_(prop.getEnumeration());
                if (prop.getMaxOccurs() > 1 || prop.getMaxOccurs() == -1) {
                    tpd.setType("array");
                    tpd.setItems(new ItemsDeclaration());
                    if (SwaggerTranslator.isPrimitiveType(prop.getType())) {
                        tpd.getItems().setType(SwaggerTranslator.toSwaggerType(prop.getType()));
                    } else {
                        tpd.getItems().setRef(prop.getType());
                    }
                } else if (SwaggerTranslator.isPrimitiveType(prop.getType())) {
                    tpd.setType(SwaggerTranslator.toSwaggerType(prop.getType()));
                } else {
                    tpd.setRef(prop.getType());
                }
                tpd.setMaximum(prop.getMax());
                tpd.setMinimum(prop.getMin());
                tpd.setUniqueItems(prop.isUniqueItems());
                md.getProperties().put(prop.getName(), tpd);
            }
            result.getModels().put(md.getId(), md);
        }
        Collections.sort(result.getApis(), new Comparator<ResourceDeclaration>(){

            @Override
            public int compare(ResourceDeclaration o1, ResourceDeclaration o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        return result;
    }

    private static Representation getRepresentationByName(Contract contract, String name) {
        if (name != null) {
            for (Representation repr : contract.getRepresentations()) {
                if (!name.equals(repr.getName())) continue;
                return repr;
            }
        }
        return null;
    }

    public static ResourceListing getResourcelisting(Definition definition) {
        ResourceListing result = new ResourceListing();
        result.setApiVersion(definition.getVersion());
        result.setInfo(new ApiInfo());
        result.setSwaggerVersion(SWAGGER_VERSION);
        if (definition.getContact() != null) {
            result.getInfo().setContact(definition.getContact());
        }
        if (definition.getLicense() != null) {
            result.getInfo().setLicenseUrl(definition.getLicense());
        }
        if (definition.getContract() != null) {
            result.getInfo().setTitle(definition.getContract().getName());
            result.getInfo().setDescription(definition.getContract().getDescription());
        }
        ArrayList<String> addedApis = new ArrayList<String>();
        if (definition.getContract() != null && definition.getContract().getResources() != null) {
            result.setApis(new ArrayList<ResourceDeclaration>());
            for (Resource resource : definition.getContract().getResources()) {
                ResourceDeclaration rd = new ResourceDeclaration();
                rd.setDescription(resource.getDescription());
                rd.setPath(ReflectUtils.getFirstSegment(resource.getResourcePath()));
                if (addedApis.contains(rd.getPath())) continue;
                addedApis.add(rd.getPath());
                result.getApis().add(rd);
            }
        }
        Collections.sort(result.getApis(), new Comparator<ResourceDeclaration>(){

            @Override
            public int compare(ResourceDeclaration o1, ResourceDeclaration o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        return result;
    }

    private static boolean isPrimitiveType(String type) {
        return "string".equals(type.toLowerCase()) || "int".equals(type.toLowerCase()) || "integer".equals(type.toLowerCase()) || "long".equals(type.toLowerCase()) || "float".equals(type.toLowerCase()) || "double".equals(type.toLowerCase()) || "date".equals(type.toLowerCase()) || "boolean".equals(type.toLowerCase()) || "bool".equals(type.toLowerCase());
    }

    private static Entity toEntity(ResourceOperationParameterDeclaration parameter) {
        Entity result = new Entity();
        if ("array".equals(parameter.getType())) {
            result.setArray(true);
            if (parameter.getItems() != null && parameter.getItems().getType() != null) {
                result.setType(parameter.getItems().getType());
            } else if (parameter.getItems() != null) {
                result.setType(parameter.getItems().getRef());
            }
        } else {
            result.setArray(false);
            result.setType(parameter.getType());
        }
        return result;
    }

    private static PathVariable toPathVariable(ResourceOperationParameterDeclaration parameter) {
        PathVariable result = new PathVariable();
        result.setName(parameter.getName());
        result.setDescription(parameter.getDescription());
        result.setType(SwaggerTranslator.toRwadefType(parameter.getType()));
        result.setArray(parameter.isAllowMultiple());
        return result;
    }

    private static QueryParameter toQueryParameter(ResourceOperationParameterDeclaration parameter) {
        QueryParameter result = new QueryParameter();
        result.setName(parameter.getName());
        result.setDescription(parameter.getDescription());
        result.setRequired(parameter.isRequired());
        result.setAllowMultiple(parameter.isAllowMultiple());
        result.setDefaultValue(parameter.getDefaultValue());
        if (parameter.getEnum_() != null && !parameter.getEnum_().isEmpty()) {
            result.setEnumeration(new ArrayList<String>());
            for (String value : parameter.getEnum_()) {
                result.getEnumeration().add(value);
            }
        }
        return result;
    }

    private static Representation toRepresentation(ModelDeclaration model, String name) {
        Representation result = new Representation();
        result.setName(name);
        result.setDescription(model.getDescription());
        for (Map.Entry<String, TypePropertyDeclaration> swagProperties : model.getProperties().entrySet()) {
            TypePropertyDeclaration swagProperty = swagProperties.getValue();
            Property property = new Property();
            property.setName(swagProperties.getKey());
            boolean isArray = "array".equals(swagProperty.getType());
            if (isArray) {
                property.setType(swagProperty.getItems().getType() != null ? swagProperty.getItems().getType() : swagProperty.getItems().getRef());
            } else if (swagProperty.getType() != null) {
                property.setType(swagProperty.getType());
            } else if (swagProperty.getRef() != null) {
                property.setType(swagProperty.getRef());
            }
            if (model.getRequired() != null) {
                property.setMinOccurs(model.getRequired().contains(swagProperties.getKey()) ? 1 : 0);
            } else {
                property.setMinOccurs(0);
            }
            property.setMaxOccurs(isArray ? -1 : 1);
            property.setDescription(swagProperty.getDescription());
            property.setMin(swagProperty.getMinimum());
            property.setMax(swagProperty.getMaximum());
            property.setUniqueItems(swagProperty.isUniqueItems());
            result.getProperties().add(property);
            LOGGER.log(Level.FINE, "Property " + property.getName() + " added.");
        }
        return result;
    }

    private static String toRwadefType(String type) {
        if ("int".equals(type)) {
            return "Integer";
        }
        if ("string".equals(type)) {
            return "String";
        }
        if ("boolean".equals(type)) {
            return "Boolean";
        }
        return type;
    }

    private static String toSwaggerType(String type) {
        if ("Integer".equals(type)) {
            return "int";
        }
        if ("String".equals(type)) {
            return "string";
        }
        if ("Boolean".equals(type)) {
            return "boolean";
        }
        return type;
    }

    public static Definition translate(ResourceListing resourceListing, Map<String, ApiDeclaration> apiDeclarations) throws TranslationException {
        SwaggerTranslator.validate(resourceListing, apiDeclarations);
        boolean containsRawTypes = false;
        ArrayList declaredTypes = new ArrayList();
        HashMap<String, List<String>> subtypes = new HashMap<String, List<String>>();
        try {
            Definition definition = new Definition();
            definition.setVersion(resourceListing.getApiVersion());
            definition.setContact(resourceListing.getInfo().getContact());
            definition.setLicense(resourceListing.getInfo().getLicenseUrl());
            Contract contract = new Contract();
            contract.setName(resourceListing.getInfo().getTitle());
            LOGGER.log(Level.FINE, "Contract " + contract.getName() + " added.");
            contract.setDescription(resourceListing.getInfo().getDescription());
            definition.setContract(contract);
            for (Map.Entry<String, ApiDeclaration> entry : apiDeclarations.entrySet()) {
                ApiDeclaration swagApiDeclaration = entry.getValue();
                List<String> apiProduces = swagApiDeclaration.getProduces();
                List<String> apiConsumes = swagApiDeclaration.getConsumes();
                for (ResourceDeclaration api : swagApiDeclaration.getApis()) {
                    ArrayList<String> declaredPathVariables = new ArrayList<String>();
                    Resource resource = new Resource();
                    resource.setResourcePath(api.getPath());
                    for (ResourceOperationDeclaration swagOperation : api.getOperations()) {
                        Representation representation;
                        String methodName = swagOperation.getMethod();
                        Operation operation = new Operation();
                        operation.setMethod(swagOperation.getMethod());
                        operation.setName(swagOperation.getNickname());
                        operation.setDescription(swagOperation.getSummary());
                        for (String produced : apiProduces.isEmpty() ? swagOperation.getProduces() : apiProduces) {
                            if (!containsRawTypes && MediaType.MULTIPART_FORM_DATA.getName().equals(produced)) {
                                representation = new Representation();
                                representation.setName("File");
                                representation.setRaw(true);
                                containsRawTypes = true;
                                contract.getRepresentations().add(representation);
                            }
                            operation.getProduces().add(produced);
                        }
                        for (String consumed : apiConsumes.isEmpty() ? swagOperation.getConsumes() : apiConsumes) {
                            if (!containsRawTypes && MediaType.MULTIPART_FORM_DATA.getName().equals(consumed)) {
                                representation = new Representation();
                                representation.setName("File");
                                representation.setRaw(true);
                                containsRawTypes = true;
                                contract.getRepresentations().add(representation);
                            }
                            operation.getConsumes().add(consumed);
                        }
                        Entity rwadOutRepr = new Entity();
                        if ("array".equals(swagOperation.getType())) {
                            LOGGER.log(Level.FINER, "Operation: " + swagOperation.getNickname() + " returns an array");
                            rwadOutRepr.setArray(true);
                            if (swagOperation.getItems().getType() != null) {
                                rwadOutRepr.setType(swagOperation.getItems().getType());
                            } else {
                                rwadOutRepr.setType(swagOperation.getItems().getRef());
                            }
                        } else {
                            LOGGER.log(Level.FINER, "Operation: " + swagOperation.getNickname() + " returns a single Representation");
                            rwadOutRepr.setArray(false);
                            if (swagOperation.getType() != null) {
                                rwadOutRepr.setType(swagOperation.getType());
                            } else {
                                rwadOutRepr.setType(swagOperation.getRef());
                            }
                        }
                        operation.setOutRepresentation(rwadOutRepr);
                        Response success = new Response();
                        success.setCode(Status.SUCCESS_OK.getCode());
                        success.setEntity(rwadOutRepr);
                        success.setDescription("Success");
                        success.setMessage(Status.SUCCESS_OK.getDescription());
                        success.setName("Success");
                        operation.getResponses().add(success);
                        for (ResourceOperationParameterDeclaration resourceOperationParameterDeclaration : swagOperation.getParameters()) {
                            if ("path".equals(resourceOperationParameterDeclaration.getParamType())) {
                                if (declaredPathVariables.contains(resourceOperationParameterDeclaration.getName())) continue;
                                declaredPathVariables.add(resourceOperationParameterDeclaration.getName());
                                PathVariable pathVariable = SwaggerTranslator.toPathVariable(resourceOperationParameterDeclaration);
                                resource.getPathVariables().add(pathVariable);
                                continue;
                            }
                            if ("body".equals(resourceOperationParameterDeclaration.getParamType())) {
                                if (operation.getInRepresentation() != null) continue;
                                Entity rwadInRepr = SwaggerTranslator.toEntity(resourceOperationParameterDeclaration);
                                operation.setInRepresentation(rwadInRepr);
                                continue;
                            }
                            if (!"query".equals(resourceOperationParameterDeclaration.getParamType())) continue;
                            QueryParameter rwadQueryParam = SwaggerTranslator.toQueryParameter(resourceOperationParameterDeclaration);
                            operation.getQueryParameters().add(rwadQueryParam);
                        }
                        if (swagOperation.getResponseMessages() != null) {
                            for (ResponseMessageDeclaration responseMessageDeclaration : swagOperation.getResponseMessages()) {
                                Response response = new Response();
                                Entity entity = new Entity();
                                entity.setType(responseMessageDeclaration.getResponseModel());
                                response.setEntity(entity);
                                response.setName("Error " + responseMessageDeclaration.getCode());
                                response.setCode(responseMessageDeclaration.getCode());
                                response.setMessage(responseMessageDeclaration.getMessage());
                                operation.getResponses().add(response);
                            }
                        }
                        resource.getOperations().add(operation);
                        LOGGER.log(Level.FINE, "Method " + methodName + " added.");
                        for (Map.Entry entry2 : swagApiDeclaration.getModels().entrySet()) {
                            ModelDeclaration model = (ModelDeclaration)entry2.getValue();
                            if (model.getSubTypes() != null && !model.getSubTypes().isEmpty()) {
                                subtypes.put(model.getId(), model.getSubTypes());
                            }
                            if (declaredTypes.contains(entry2.getKey())) continue;
                            declaredTypes.add(entry2.getKey());
                            Representation rwadRepr = SwaggerTranslator.toRepresentation(model, (String)entry2.getKey());
                            contract.getRepresentations().add(rwadRepr);
                            LOGGER.log(Level.FINE, "Representation " + (String)entry2.getKey() + " added.");
                        }
                        for (Map.Entry entry3 : subtypes.entrySet()) {
                            List subtypesOf = (List)entry3.getValue();
                            for (String subtypeOf : subtypesOf) {
                                Representation repr = SwaggerTranslator.getRepresentationByName(contract, subtypeOf);
                                repr.setExtendedType((String)entry3.getKey());
                            }
                        }
                    }
                    definition.getContract().getResources().add(resource);
                    LOGGER.log(Level.FINE, "Resource " + api.getPath() + " added.");
                }
                if (definition.getEndpoint() != null) continue;
                definition.setEndpoint(swagApiDeclaration.getBasePath());
            }
            LOGGER.log(Level.FINE, "Definition successfully retrieved from Swagger definition");
            return definition;
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                throw new TranslationException("file", ((FileNotFoundException)e).getMessage());
            }
            throw new TranslationException("compliance", "Impossible to read your API definition, check your Swagger specs compliance");
        }
    }

    private static void validate(ResourceListing resourceListing, Map<String, ApiDeclaration> apiDeclarations) throws TranslationException {
        int adSize;
        int rlSize = resourceListing.getApis().size();
        if (rlSize < (adSize = apiDeclarations.size())) {
            throw new TranslationException("file", "One of your API declarations is not mapped in your resource listing");
        }
        if (rlSize > adSize) {
            throw new TranslationException("file", "Some API declarations are missing");
        }
    }

    private SwaggerTranslator() {
    }
}

