/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.conversion;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.ext.apispark.internal.conversion.SwaggerTranslator;
import org.restlet.ext.apispark.internal.conversion.TranslationException;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.swagger.ApiDeclaration;
import org.restlet.ext.apispark.internal.model.swagger.ResourceDeclaration;
import org.restlet.ext.apispark.internal.model.swagger.ResourceListing;
import org.restlet.resource.ClientResource;

public abstract class SwaggerUtils {
    protected static Logger LOGGER = Logger.getLogger(SwaggerUtils.class.getName());

    private static ClientResource createAuthenticatedClientResource(String url, String userName, String password) {
        ClientResource cr = new ClientResource(url);
        cr.accept(new Metadata[]{MediaType.APPLICATION_JSON});
        if (!SwaggerUtils.isEmpty(userName) && !SwaggerUtils.isEmpty(password)) {
            cr.setChallengeResponse(ChallengeScheme.HTTP_BASIC, userName, password);
        }
        return cr;
    }

    public static Definition getDefinition(String swaggerUrl, String userName, String password) throws TranslationException {
        if (swaggerUrl == null) {
            throw new TranslationException("url", "You did not provide any URL");
        }
        Pattern p = Pattern.compile("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
        boolean remote = p.matcher(swaggerUrl).matches();
        ResourceListing resourceListing = new ResourceListing();
        HashMap<String, ApiDeclaration> apis = new HashMap<String, ApiDeclaration>();
        if (remote) {
            LOGGER.log(Level.FINE, "Reading file: " + swaggerUrl);
            resourceListing = (ResourceListing)SwaggerUtils.createAuthenticatedClientResource(swaggerUrl, userName, password).get(ResourceListing.class);
            for (ResourceDeclaration api : resourceListing.getApis()) {
                LOGGER.log(Level.FINE, "Reading file: " + swaggerUrl + api.getPath());
                apis.put(api.getPath().replaceAll("/", ""), (ApiDeclaration)SwaggerUtils.createAuthenticatedClientResource(swaggerUrl + api.getPath(), userName, password).get(ApiDeclaration.class));
            }
        } else {
            File resourceListingFile = new File(swaggerUrl);
            ObjectMapper om = new ObjectMapper();
            try {
                resourceListing = (ResourceListing)om.readValue(resourceListingFile, ResourceListing.class);
                String basePath = resourceListingFile.getParent();
                LOGGER.log(Level.FINE, "Base path: " + basePath);
                for (ResourceDeclaration api : resourceListing.getApis()) {
                    LOGGER.log(Level.FINE, "Reading file " + basePath + api.getPath());
                    apis.put(api.getPath(), (ApiDeclaration)om.readValue(new File(basePath + api.getPath()), ApiDeclaration.class));
                }
            }
            catch (IOException e) {
                throw new TranslationException("file", e.getMessage());
            }
        }
        return SwaggerTranslator.translate(resourceListing, apis);
    }

    private static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private SwaggerUtils() {
    }
}

