/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.firewall.rule;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.ext.apispark.internal.firewall.rule.CounterResult;
import org.restlet.ext.apispark.internal.firewall.rule.FirewallCounterRule;
import org.restlet.ext.apispark.internal.firewall.rule.counter.ConcurrentCounter;
import org.restlet.ext.apispark.internal.firewall.rule.policy.CountingPolicy;

public class ConcurrentFirewallCounterRule
extends FirewallCounterRule {
    private LoadingCache<String, ConcurrentCounter> cache;

    public ConcurrentFirewallCounterRule(CountingPolicy countingPolicy) {
        super(countingPolicy);
        this.initializeCache();
    }

    @Override
    protected void decrementCounter(String countedValue) {
        Context.getCurrentLogger().log(Level.FINE, "Counter " + this.getClass() + " decremented for value: " + countedValue);
        ConcurrentCounter counter = (ConcurrentCounter)this.cache.getUnchecked((Object)countedValue);
        counter.decrement();
    }

    @Override
    protected CounterResult incrementCounter(String countedValue) {
        ConcurrentCounter counter = (ConcurrentCounter)this.cache.getUnchecked((Object)countedValue);
        return counter.increment();
    }

    private void initializeCache() {
        CacheLoader<String, ConcurrentCounter> loader = new CacheLoader<String, ConcurrentCounter>(){

            public ConcurrentCounter load(String key) {
                return new ConcurrentCounter();
            }
        };
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)loader);
    }
}

