/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.firewall.rule;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.restlet.ext.apispark.internal.firewall.rule.CounterResult;
import org.restlet.ext.apispark.internal.firewall.rule.FirewallCounterRule;
import org.restlet.ext.apispark.internal.firewall.rule.counter.PeriodicCounter;
import org.restlet.ext.apispark.internal.firewall.rule.policy.CountingPolicy;

public class PeriodicFirewallCounterRule
extends FirewallCounterRule {
    private LoadingCache<String, PeriodicCounter> cache;
    private int period;

    public PeriodicFirewallCounterRule(int period, CountingPolicy countingPolicy) {
        super(countingPolicy);
        this.period = period;
        this.initializeCache();
    }

    @Override
    protected void decrementCounter(String countedValue) {
    }

    protected int getPeriod() {
        return this.period;
    }

    @Override
    protected CounterResult incrementCounter(String countedValue) {
        PeriodicCounter individualCounter = (PeriodicCounter)this.cache.getUnchecked((Object)countedValue);
        return individualCounter.increment();
    }

    private void initializeCache() {
        CacheLoader<String, PeriodicCounter> loader = new CacheLoader<String, PeriodicCounter>(){

            public PeriodicCounter load(String key) {
                return PeriodicFirewallCounterRule.this.initializeCounter();
            }
        };
        this.cache = CacheBuilder.newBuilder().expireAfterAccess((long)(2 * this.period), TimeUnit.SECONDS).build((CacheLoader)loader);
    }

    public PeriodicCounter initializeCounter() {
        return new PeriodicCounter(this.getPeriod());
    }
}

