/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.info;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.ext.apispark.internal.info.DocumentationInfo;
import org.restlet.ext.apispark.internal.info.DocumentedInfo;
import org.restlet.ext.apispark.internal.info.MethodInfo;
import org.restlet.ext.apispark.internal.info.ParameterInfo;
import org.restlet.ext.apispark.internal.info.PropertyInfo;
import org.restlet.ext.apispark.internal.reflect.ReflectUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;

public class RepresentationInfo
extends DocumentedInfo {
    private boolean collection;
    private String identifier;
    private MediaType mediaType;
    private String name;
    private List<ParameterInfo> parameters;
    private List<PropertyInfo> properties;
    private boolean raw;
    private String reference;
    private Class<?> type;

    public static RepresentationInfo describe(MethodInfo methodInfo, Class<?> representationClass, Type representationType, Variant variant) {
        RepresentationInfo result = null;
        if (representationClass != null) {
            result = RepresentationInfo.introspect(representationClass, representationType, variant.getMediaType());
        }
        return result;
    }

    public static RepresentationInfo introspect(Class<?> clazz, Type type, MediaType mediaType) {
        boolean generic;
        RepresentationInfo result = new RepresentationInfo(mediaType);
        result.setCollection(ReflectUtils.isListType(clazz));
        Class<?> c = ReflectUtils.getSimpleClass(type);
        result.setType(c == null ? clazz : c);
        boolean bl = generic = c != null && !c.getCanonicalName().equals(clazz.getCanonicalName());
        if (generic) {
            result.setIdentifier(clazz.getName() + c.getName());
            result.setName(clazz.getSimpleName() + c.getSimpleName());
        } else {
            result.setIdentifier(result.getType().getName());
            result.setName(result.getType().getSimpleName());
        }
        if (Representation.class.isAssignableFrom(clazz) || ReflectUtils.isJdkClass(c)) {
            result.setRaw(true);
        } else {
            for (Field field : ReflectUtils.getAllDeclaredFields(clazz)) {
                if ("serialVersionUID".equals(field.getName())) continue;
                PropertyInfo property = new PropertyInfo();
                property.setName(field.getName());
                property.setType(ReflectUtils.getSimpleClass(field));
                property.setMinOccurs(0);
                if (ReflectUtils.isListType(field.getType())) {
                    property.setMaxOccurs(-1);
                } else {
                    property.setMaxOccurs(1);
                }
                result.getProperties().add(property);
            }
        }
        return result;
    }

    public RepresentationInfo() {
    }

    public RepresentationInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public RepresentationInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public RepresentationInfo(MediaType mediaType) {
        this.setMediaType(mediaType);
    }

    public RepresentationInfo(String documentation) {
        super(documentation);
    }

    public RepresentationInfo(Variant variant) {
        this.setMediaType(variant.getMediaType());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParameterInfo> getParameters() {
        List<ParameterInfo> p = this.parameters;
        if (p == null) {
            RepresentationInfo representationInfo = this;
            synchronized (representationInfo) {
                p = this.parameters;
                if (p == null) {
                    this.parameters = p = new ArrayList<ParameterInfo>();
                }
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertyInfo> getProperties() {
        List<PropertyInfo> p = this.properties;
        if (p == null) {
            RepresentationInfo representationInfo = this;
            synchronized (representationInfo) {
                p = this.properties;
                if (p == null) {
                    this.properties = p = new ArrayList<PropertyInfo>();
                }
            }
        }
        return p;
    }

    public String getReference() {
        return this.reference;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public void setCollection(boolean collection) {
        this.collection = collection;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(List<ParameterInfo> parameters) {
        this.parameters = parameters;
    }

    public void setProperties(List<PropertyInfo> properties) {
        this.properties = properties;
    }

    public void setRaw(boolean raw) {
        this.raw = raw;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }
}

