/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Resource;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;

public class IntrospectionUtils {
    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static void printOption(PrintStream o, String option, String ... strings) {
        IntrospectionUtils.printSentence(o, 7, option);
        IntrospectionUtils.printSentence(o, 14, strings);
    }

    public static void printSentence(PrintStream o, int shift, String ... strings) {
        int blockLength = 80 - shift - 1;
        String tab = "";
        for (int i = 0; i < shift; ++i) {
            tab = tab.concat(" ");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(strings[i]);
        }
        String sentence = sb.toString();
        int index = 0;
        while (index < sentence.length() - 1) {
            o.print(tab);
            int length = Math.min(index + blockLength, sentence.length() - 1);
            if (length - index < blockLength) {
                o.println(sentence.substring(index));
                index = length + 1;
                continue;
            }
            if (sentence.charAt(length) == ' ') {
                o.println(sentence.substring(index, length));
                index = length + 1;
                continue;
            }
            if ((length = sentence.substring(index, length - 1).lastIndexOf(32)) != -1) {
                o.println(sentence.substring(index, index + length));
                index += length + 1;
                continue;
            }
            length = sentence.substring(index).indexOf(32);
            if (length != -1) {
                o.println(sentence.substring(index, index + length));
                index += length + 1;
                continue;
            }
            o.println(sentence.substring(index));
            index = sentence.length();
        }
    }

    public static void printSentence(PrintStream o, String ... strings) {
        IntrospectionUtils.printSentence(o, 7, strings);
    }

    public static void printSynopsis(PrintStream o, Class<?> clazz, String command) {
        IntrospectionUtils.printSentence(o, 7, clazz.getName(), command);
    }

    public static void sendDefinition(Definition definition, String definitionId, String ulogin, String upwd, String serviceUrl, Logger LOGGER) {
        block10: {
            Collections.sort(definition.getContract().getRepresentations(), new Comparator<Representation>(){

                @Override
                public int compare(Representation o1, Representation o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            Collections.sort(definition.getContract().getResources(), new Comparator<Resource>(){

                @Override
                public int compare(Resource o1, Resource o2) {
                    return o1.getResourcePath().compareTo(o2.getResourcePath());
                }
            });
            try {
                ClientResource cr = new ClientResource(serviceUrl);
                cr.setChallengeResponse(ChallengeScheme.HTTP_BASIC, ulogin, upwd);
                if (definitionId == null) {
                    cr.addSegment("definitions");
                    LOGGER.info("Create a new documentation");
                    cr.post((Object)definition, MediaType.APPLICATION_JSON);
                } else {
                    cr.addSegment("apis").addSegment(definitionId).addSegment("definitions");
                    LOGGER.info("Update the documentation of " + cr.getReference().toString());
                    cr.put((Object)definition, MediaType.APPLICATION_JSON);
                }
                LOGGER.fine("Display result");
                System.out.println("Process successfully achieved.");
                if (cr.getResponseEntity() != null && cr.getResponseEntity().isAvailable()) {
                    try {
                        cr.getResponseEntity().write((OutputStream)System.out);
                        System.out.println();
                    }
                    catch (IOException e) {
                        LOGGER.warning("Request successfully achieved by the server, but it's response cannot be printed");
                    }
                }
                if (cr.getLocationRef() != null) {
                    System.out.println("Your Web API documentation is accessible at this URL: " + cr.getLocationRef());
                }
            }
            catch (ResourceException e) {
                if (e.getStatus().isConnectorError()) {
                    LOGGER.severe("Cannot reach the remote service, could you check your network connection?");
                    LOGGER.severe("Could you check that the following service is up? " + serviceUrl);
                }
                if (e.getStatus().isClientError()) {
                    LOGGER.severe("Check that you provide valid credentials, or valid service url.");
                }
                if (!e.getStatus().isServerError()) break block10;
                LOGGER.severe("The server side encounters some issues, please try later.");
            }
        }
    }
}

