/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.Context;
import org.restlet.ext.apispark.internal.firewall.FirewallFilter;
import org.restlet.ext.apispark.internal.firewall.handler.BlockingHandler;
import org.restlet.ext.apispark.internal.firewall.handler.policy.PerValueLimitPolicy;
import org.restlet.ext.apispark.internal.firewall.handler.policy.RoleLimitPolicy;
import org.restlet.ext.apispark.internal.firewall.handler.policy.UniqueLimitPolicy;
import org.restlet.ext.apispark.internal.firewall.rule.ConcurrentFirewallCounterRule;
import org.restlet.ext.apispark.internal.firewall.rule.FirewallRule;
import org.restlet.ext.apispark.internal.firewall.rule.PeriodicFirewallCounterRule;
import org.restlet.ext.apispark.internal.firewall.rule.policy.HostDomainCountingPolicy;
import org.restlet.ext.apispark.internal.firewall.rule.policy.IpAddressCountingPolicy;
import org.restlet.ext.apispark.internal.firewall.rule.policy.UserCountingPolicy;
import org.restlet.routing.Filter;
import org.restlet.service.Service;

public class FirewallService
extends Service {
    private List<FirewallRule> rules = new ArrayList<FirewallRule>();

    public FirewallService() {
        this(true);
    }

    public FirewallService(boolean enabled) {
        super(enabled);
    }

    private void add(FirewallRule rule) {
        this.rules.add(rule);
    }

    public void addHostDomainConcurrencyCounter(int limit) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new HostDomainCountingPolicy());
        rule.addHandler(new BlockingHandler(new UniqueLimitPolicy(limit)));
        this.add(rule);
    }

    public void addHostDomainPeriodicCounter(int period, int limit) {
        PeriodicFirewallCounterRule rule = new PeriodicFirewallCounterRule(period, new HostDomainCountingPolicy());
        rule.addHandler(new BlockingHandler(new UniqueLimitPolicy(limit)));
    }

    public void addIpAddressesBlackList(List<String> blackList) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new IpAddressCountingPolicy());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String ip : blackList) {
            map.put(ip, 0);
        }
        rule.addHandler(new BlockingHandler(new PerValueLimitPolicy(map, Integer.MAX_VALUE)));
        this.add(rule);
    }

    public void addIpAddressesConcurrencyCounter(int limit) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new IpAddressCountingPolicy());
        rule.addHandler(new BlockingHandler(new UniqueLimitPolicy(limit)));
        this.add(rule);
    }

    public void addIpAddressesPeriodicCounter(int period, int limit) {
        PeriodicFirewallCounterRule rule = new PeriodicFirewallCounterRule(period, new IpAddressCountingPolicy());
        rule.addHandler(new BlockingHandler(new UniqueLimitPolicy(limit)));
        this.add(rule);
    }

    public void addIpAddressesWhiteList(List<String> whiteList) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new IpAddressCountingPolicy());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String ip : whiteList) {
            map.put(ip, Integer.MAX_VALUE);
        }
        rule.addHandler(new BlockingHandler(new PerValueLimitPolicy(map, 0)));
        this.add(rule);
    }

    public void addRolesConcurrencyCounter(Map<String, Integer> limitsPerRole) {
        this.addRolesConcurrencyCounter(limitsPerRole, 0);
    }

    public void addRolesConcurrencyCounter(Map<String, Integer> limitsPerRole, int defaultLimit) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new UserCountingPolicy());
        rule.addHandler(new BlockingHandler(new RoleLimitPolicy(limitsPerRole, defaultLimit)));
        this.add(rule);
    }

    public void addRolesPeriodicCounter(int period, Map<String, Integer> limitsPerRole) {
        this.addRolesPeriodicCounter(period, limitsPerRole, 0);
    }

    public void addRolesPeriodicCounter(int period, Map<String, Integer> limitsPerRole, int defaultLimit) {
        PeriodicFirewallCounterRule rule = new PeriodicFirewallCounterRule(period, new UserCountingPolicy());
        rule.addHandler(new BlockingHandler(new RoleLimitPolicy(limitsPerRole, defaultLimit)));
        this.add(rule);
    }

    public Filter createInboundFilter(Context context) {
        return new FirewallFilter(context, this.rules);
    }
}

