/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.conversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.engine.connector.ConnectorHelper;
import org.restlet.ext.apispark.internal.info.ApplicationInfo;
import org.restlet.ext.apispark.internal.info.DocumentationInfo;
import org.restlet.ext.apispark.internal.info.MethodInfo;
import org.restlet.ext.apispark.internal.info.ParameterInfo;
import org.restlet.ext.apispark.internal.info.ParameterStyle;
import org.restlet.ext.apispark.internal.info.PropertyInfo;
import org.restlet.ext.apispark.internal.info.RepresentationInfo;
import org.restlet.ext.apispark.internal.info.ResourceInfo;
import org.restlet.ext.apispark.internal.info.ResponseInfo;
import org.restlet.ext.apispark.internal.model.Contract;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.model.Entity;
import org.restlet.ext.apispark.internal.model.Header;
import org.restlet.ext.apispark.internal.model.Operation;
import org.restlet.ext.apispark.internal.model.PathVariable;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.QueryParameter;
import org.restlet.ext.apispark.internal.model.Representation;
import org.restlet.ext.apispark.internal.model.Resource;
import org.restlet.ext.apispark.internal.model.Response;
import org.restlet.ext.apispark.internal.reflect.ReflectUtils;

public class IntrospectionTranslator {
    private static void addRepresentations(Map<String, RepresentationInfo> mapReps, List<RepresentationInfo> representations) {
        if (representations != null) {
            for (RepresentationInfo r : representations) {
                if (mapReps.containsKey(r.getIdentifier())) continue;
                mapReps.put(r.getIdentifier(), r);
            }
        }
    }

    private static void addResources(ApplicationInfo application, Contract contract, List<ResourceInfo> resources, String basePath, Map<String, RepresentationInfo> mapReps, Logger logger) {
        for (ResourceInfo ri : resources) {
            Resource resource = new Resource();
            resource.setDescription(IntrospectionTranslator.toString(ri.getDocumentations()));
            resource.setName(ri.getIdentifier());
            if (ri.getPath() == null) {
                resource.setResourcePath("/");
            } else if (!ri.getPath().startsWith("/")) {
                resource.setResourcePath("/" + ri.getPath());
            } else {
                resource.setResourcePath(ri.getPath());
            }
            resource.setPathVariables(new ArrayList<PathVariable>());
            for (ParameterInfo pi : ri.getParameters()) {
                if (!ParameterStyle.TEMPLATE.equals((Object)pi.getStyle())) continue;
                PathVariable pathVariable = new PathVariable();
                pathVariable.setDescription(IntrospectionTranslator.toString(pi.getDocumentations()));
                pathVariable.setName(pi.getName());
                resource.getPathVariables().add(pathVariable);
            }
            if (!ri.getChildResources().isEmpty()) {
                IntrospectionTranslator.addResources(application, contract, ri.getChildResources(), resource.getResourcePath(), mapReps, logger);
            }
            logger.fine("Resource " + ri.getPath() + " added.");
            if (ri.getMethods().isEmpty()) {
                logger.warning("Resource " + ri.getIdentifier() + " has no methods.");
                continue;
            }
            resource.setOperations(new ArrayList<Operation>());
            for (MethodInfo mi : ri.getMethods()) {
                Entity entity;
                QueryParameter queryParameter;
                Header header;
                String mediaType;
                String methodName = mi.getMethod().getName();
                if ("OPTIONS".equals(methodName) || "PATCH".equals(methodName)) {
                    logger.fine("Method " + methodName + " ignored.");
                    continue;
                }
                logger.fine("Method " + methodName + " added.");
                Operation operation = new Operation();
                operation.setDescription(IntrospectionTranslator.toString(mi.getDocumentations()));
                operation.setName(methodName);
                operation.setMethod(mi.getMethod().getName());
                if (mi.getRequest() != null && mi.getRequest().getRepresentations() != null) {
                    List<RepresentationInfo> consumed = mi.getRequest().getRepresentations();
                    for (RepresentationInfo reprInfo : consumed) {
                        mediaType = reprInfo.getMediaType().getName();
                        operation.getConsumes().add(mediaType);
                    }
                }
                if (mi.getResponse() != null && mi.getResponse().getRepresentations() != null) {
                    List<RepresentationInfo> produced = mi.getResponse().getRepresentations();
                    for (RepresentationInfo reprInfo : produced) {
                        mediaType = reprInfo.getMediaType().getName();
                        operation.getProduces().add(mediaType);
                    }
                }
                operation.setHeaders(new ArrayList<Header>());
                operation.setQueryParameters(new ArrayList<QueryParameter>());
                if (mi.getRequest() != null) {
                    for (ParameterInfo pi : mi.getRequest().getParameters()) {
                        if (ParameterStyle.HEADER.equals((Object)pi.getStyle())) {
                            header = new Header();
                            header.setAllowMultiple(pi.isRepeating());
                            header.setDefaultValue(pi.getDefaultValue());
                            header.setDescription(IntrospectionTranslator.toString(pi.getDocumentations(), pi.getDefaultValue()));
                            header.setName(pi.getName());
                            header.setEnumeration(new ArrayList<String>());
                            header.setRequired(pi.isRequired());
                            operation.getHeaders().add(header);
                            continue;
                        }
                        if (!ParameterStyle.QUERY.equals((Object)pi.getStyle())) continue;
                        queryParameter = new QueryParameter();
                        queryParameter.setAllowMultiple(pi.isRepeating());
                        queryParameter.setDefaultValue(pi.getDefaultValue());
                        queryParameter.setDescription(IntrospectionTranslator.toString(pi.getDocumentations(), pi.getDefaultValue()));
                        queryParameter.setName(pi.getName());
                        queryParameter.setEnumeration(new ArrayList<String>());
                        queryParameter.setRequired(pi.isRequired());
                        operation.getQueryParameters().add(queryParameter);
                    }
                }
                for (ParameterInfo pi : mi.getParameters()) {
                    if (ParameterStyle.HEADER.equals((Object)pi.getStyle())) {
                        header = new Header();
                        header.setAllowMultiple(pi.isRepeating());
                        header.setDefaultValue(pi.getDefaultValue());
                        header.setDescription(IntrospectionTranslator.toString(pi.getDocumentations(), pi.getDefaultValue()));
                        header.setName(pi.getName());
                        header.setEnumeration(new ArrayList<String>());
                        header.setRequired(pi.isRequired());
                        operation.getHeaders().add(header);
                        continue;
                    }
                    if (!ParameterStyle.QUERY.equals((Object)pi.getStyle())) continue;
                    queryParameter = new QueryParameter();
                    queryParameter.setAllowMultiple(pi.isRepeating());
                    queryParameter.setDefaultValue(pi.getDefaultValue());
                    queryParameter.setDescription(IntrospectionTranslator.toString(pi.getDocumentations(), pi.getDefaultValue()));
                    queryParameter.setName(pi.getName());
                    queryParameter.setEnumeration(new ArrayList<String>());
                    queryParameter.setRequired(pi.isRequired());
                    operation.getQueryParameters().add(queryParameter);
                }
                if (mi.getRequest() != null && mi.getRequest().getRepresentations() != null && !mi.getRequest().getRepresentations().isEmpty()) {
                    IntrospectionTranslator.addRepresentations(mapReps, mi.getRequest().getRepresentations());
                    entity = new Entity();
                    entity.setType(mi.getRequest().getRepresentations().get(0).getType().getSimpleName());
                    entity.setArray(mi.getRequest().getRepresentations().get(0).isCollection());
                    operation.setInRepresentation(entity);
                }
                if (mi.getResponses() != null && !mi.getResponses().isEmpty()) {
                    operation.setResponses(new ArrayList<Response>());
                    entity = new Entity();
                    if (!mi.getResponse().getRepresentations().isEmpty()) {
                        entity.setType(mi.getResponse().getRepresentations().get(0).getType().getSimpleName());
                        entity.setArray(mi.getResponse().getRepresentations().get(0).isCollection());
                    }
                    operation.setOutRepresentation(entity);
                    for (ResponseInfo rio : mi.getResponses()) {
                        IntrospectionTranslator.addRepresentations(mapReps, rio.getRepresentations());
                        if (rio.getStatuses().isEmpty()) continue;
                        Status status = rio.getStatuses().get(0);
                        Response response = new Response();
                        response.setEntity(entity);
                        response.setCode(status.getCode());
                        response.setName(IntrospectionTranslator.toString(rio.getDocumentations()));
                        response.setDescription(IntrospectionTranslator.toString(rio.getDocumentations()));
                        response.setMessage(status.getDescription());
                        operation.getResponses().add(response);
                    }
                }
                resource.getOperations().add(operation);
            }
            contract.getResources().add(resource);
        }
    }

    private static String convertPrimitiveTypes(String type) {
        if ("int".equals(type)) {
            return "Integer";
        }
        if ("boolean".equals(type)) {
            return "Boolean";
        }
        if ("long".equals(type)) {
            return "Long";
        }
        if ("float".equals(type)) {
            return "Float";
        }
        if ("double".equals(type)) {
            return "Double";
        }
        return type;
    }

    private static boolean isPrimitiveType(String type) {
        String[] primitiveTypes = new String[]{"int", "Integer", "boolean", "Boolean", "double", "Double", "float", "Float", "long", "Long"};
        List<String> smartPrimitiveTypes = Arrays.asList(primitiveTypes);
        return smartPrimitiveTypes.contains(type);
    }

    public static Definition toDefinition(ApplicationInfo application, Logger logger) {
        Definition result = null;
        if (application != null) {
            RepresentationInfo r;
            result = new Definition();
            result.setVersion(application.getVersion());
            if (application.getResources().getBaseRef() != null) {
                result.setEndpoint(application.getResources().getBaseRef().toString());
            }
            Contract contract = new Contract();
            result.setContract(contract);
            contract.setDescription(IntrospectionTranslator.toString(application.getDocumentations()));
            contract.setName(application.getName());
            if (contract.getName() == null || contract.getName().isEmpty()) {
                contract.setName(application.getClass().getName());
                logger.log(Level.WARNING, "Please provide a name to your application, used " + contract.getName() + " by default.");
            }
            logger.fine("Contract " + contract.getName() + " added.");
            contract.setResources(new ArrayList<Resource>());
            HashMap<String, RepresentationInfo> mapReps = new HashMap<String, RepresentationInfo>();
            IntrospectionTranslator.addResources(application, contract, application.getResources().getResources(), result.getEndpoint(), mapReps, logger);
            ArrayList<String> protocols = new ArrayList<String>();
            for (ConnectorHelper helper : Engine.getInstance().getRegisteredServers()) {
                for (Protocol protocol : helper.getProtocols()) {
                    if (protocols.contains(protocol.getName())) continue;
                    logger.fine("Protocol " + protocol.getName() + " added.");
                    protocols.add(protocol.getName());
                }
            }
            contract.setRepresentations(new ArrayList<Representation>());
            for (RepresentationInfo ri : application.getRepresentations()) {
                if (mapReps.containsKey(ri.getIdentifier())) continue;
                mapReps.put(ri.getIdentifier(), ri);
            }
            ArrayList<RepresentationInfo> toBeAdded = new ArrayList<RepresentationInfo>();
            for (RepresentationInfo ri : mapReps.values()) {
                Class<?> parentType;
                if (ri.isRaw()) continue;
                if (ri.isCollection() && !mapReps.containsKey(ri.getType().getName())) {
                    RepresentationInfo r2 = new RepresentationInfo(ri.getMediaType());
                    r2.setType(ri.getType());
                    toBeAdded.add(r2);
                }
                if ((parentType = ri.getType().getSuperclass()) != null && ReflectUtils.isJdkClass(parentType)) {
                    parentType = null;
                }
                if (parentType != null && !mapReps.containsKey(parentType.getName())) {
                    RepresentationInfo r3 = new RepresentationInfo(ri.getMediaType());
                    r3.setType(parentType);
                    toBeAdded.add(r3);
                }
                for (PropertyInfo pi : ri.getProperties()) {
                    if (pi.getType() == null || mapReps.containsKey(pi.getType().getName()) || toBeAdded.contains(pi.getType())) continue;
                    r = new RepresentationInfo(ri.getMediaType());
                    r.setType(pi.getType());
                    toBeAdded.add(r);
                }
            }
            while (!toBeAdded.isEmpty()) {
                RepresentationInfo[] tab = new RepresentationInfo[toBeAdded.size()];
                toBeAdded.toArray(tab);
                toBeAdded.clear();
                for (int i = 0; i < tab.length; ++i) {
                    RepresentationInfo current = tab[i];
                    if (current.isRaw() || ReflectUtils.isJdkClass(current.getType()) || mapReps.containsKey(current.getName())) continue;
                    RepresentationInfo ri = RepresentationInfo.introspect(current.getType(), null, current.getMediaType());
                    mapReps.put(ri.getIdentifier(), ri);
                    Class<?> parentType = ri.getType().getSuperclass();
                    if (parentType != null && ReflectUtils.isJdkClass(parentType)) {
                        parentType = null;
                    }
                    if (parentType != null && !mapReps.containsKey(parentType.getName())) {
                        r = new RepresentationInfo(ri.getMediaType());
                        r.setType(parentType);
                        toBeAdded.add(r);
                    }
                    for (PropertyInfo prop : ri.getProperties()) {
                        if (prop.getType() == null || mapReps.containsKey(prop.getType().getName()) || toBeAdded.contains(prop.getType())) continue;
                        RepresentationInfo r4 = new RepresentationInfo(ri.getMediaType());
                        r4.setType(prop.getType());
                        toBeAdded.add(r4);
                    }
                }
            }
            for (RepresentationInfo ri : mapReps.values()) {
                if (ri.isCollection()) continue;
                logger.fine("Representation " + ri.getName() + " added.");
                Representation rep = new Representation();
                rep.setDescription(IntrospectionTranslator.toString(ri.getDocumentations()));
                rep.setName(ri.getName());
                rep.setProperties(new ArrayList<Property>());
                for (PropertyInfo pi : ri.getProperties()) {
                    logger.fine("Property " + pi.getName() + " added.");
                    Property p = new Property();
                    p.setDefaultValue(pi.getDefaultValue());
                    p.setDescription(pi.getDescription());
                    p.setMax(pi.getMax());
                    p.setMaxOccurs(pi.getMaxOccurs());
                    p.setMin(pi.getMin());
                    p.setMinOccurs(pi.getMinOccurs());
                    p.setName(pi.getName());
                    p.setEnumeration(pi.getEnumeration());
                    if (pi.getType() != null) {
                        String type = pi.getType().getSimpleName();
                        if (IntrospectionTranslator.isPrimitiveType(type)) {
                            p.setType(IntrospectionTranslator.convertPrimitiveTypes(pi.getType().getSimpleName()));
                        } else {
                            p.setType(type);
                        }
                    }
                    p.setUniqueItems(pi.isUniqueItems());
                    rep.getProperties().add(p);
                }
                rep.setRaw(ri.isRaw() || ReflectUtils.isJdkClass(ri.getType()));
                contract.getRepresentations().add(rep);
            }
        }
        Collections.sort(result.getContract().getRepresentations(), new Comparator<Representation>(){

            @Override
            public int compare(Representation o1, Representation o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Collections.sort(result.getContract().getResources(), new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                return o1.getResourcePath().compareTo(o2.getResourcePath());
            }
        });
        return result;
    }

    private static String toString(List<DocumentationInfo> dis) {
        return IntrospectionTranslator.toString(dis, "");
    }

    private static String toString(List<DocumentationInfo> dis, String defaultValue) {
        if (dis != null && !dis.isEmpty()) {
            StringBuilder d = new StringBuilder();
            for (DocumentationInfo doc : dis) {
                if (doc.getTextContent() == null) continue;
                d.append(doc.getTextContent());
            }
            if (d.length() > 0) {
                return d.toString();
            }
        }
        return defaultValue;
    }

    private IntrospectionTranslator() {
    }
}

