/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.firewall.handler.policy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restlet.Request;
import org.restlet.ext.apispark.internal.firewall.handler.policy.LimitPolicy;
import org.restlet.security.Role;

public class RoleLimitPolicy
extends LimitPolicy {
    public int defaultLimit;
    private Map<String, Integer> limitsPerRole;

    public RoleLimitPolicy() {
        this(new HashMap<String, Integer>(), 0);
    }

    public RoleLimitPolicy(int defaultLimit) {
        this(new HashMap<String, Integer>(), defaultLimit);
    }

    public RoleLimitPolicy(Map<String, Integer> limitsPerRole) {
        this(limitsPerRole, 0);
    }

    public RoleLimitPolicy(Map<String, Integer> limitsPerRole, int defaultLimit) {
        this.limitsPerRole = limitsPerRole;
        this.defaultLimit = defaultLimit;
    }

    public void addRole(String role, int limit) {
        this.limitsPerRole.put(role, limit);
    }

    @Override
    public int getLimit(Request request, String countedValue) {
        int result = this.defaultLimit;
        List roles = request.getClientInfo().getRoles();
        for (Role role : roles) {
            if (!this.limitsPerRole.containsKey(role.getName()) || this.limitsPerRole.get(role.getName()) <= result) continue;
            result = this.limitsPerRole.get(role.getName());
        }
        return result;
    }
}

