/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.firewall.rule.counter;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.ext.apispark.internal.firewall.rule.CounterResult;
import org.restlet.ext.apispark.internal.firewall.rule.counter.Counter;

public class PeriodicCounter
extends Counter {
    private int period;
    private Stopwatch stopwatch;

    public PeriodicCounter(int period) {
        this.period = period;
        this.stopwatch = Stopwatch.createStarted();
    }

    @Override
    public void decrement() {
    }

    @Override
    public synchronized CounterResult increment() {
        if (this.stopwatch.elapsed(TimeUnit.SECONDS) > (long)this.period) {
            Context.getCurrentLogger().log(Level.FINE, "Period reinitialized.");
            this.stopwatch.reset();
            this.stopwatch.start();
            this.value = 0;
        }
        ++this.value;
        CounterResult counterResult = new CounterResult();
        counterResult.setConsumed(this.value);
        counterResult.setElapsed(this.stopwatch.elapsed(TimeUnit.SECONDS));
        counterResult.setReset(System.currentTimeMillis() / 1000L + (long)this.period - this.stopwatch.elapsed(TimeUnit.SECONDS));
        return counterResult;
    }
}

