/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark;

import org.restlet.Context;
import org.restlet.ext.apispark.internal.agent.AgentConfig;
import org.restlet.ext.apispark.internal.agent.AgentFilter;
import org.restlet.routing.Filter;
import org.restlet.service.Service;

public class AgentService
extends Service {
    public static final String DEFAULT_AGENT_SERVICE_URL = "https://apispark.restlet.com";
    private char[] agentSecret;
    private String agentServiceUrl = "https://apispark.restlet.com";
    private String agentUsername;
    private Integer cell;
    private Integer cellVersion;

    public AgentService() {
        super(true);
    }

    public AgentService(String agentUsername, char[] agentSecret, Integer cell, Integer cellVersion) {
        this(DEFAULT_AGENT_SERVICE_URL, agentUsername, agentSecret, cell, cellVersion);
    }

    public AgentService(String agentServiceUrl, String agentUsername, char[] agentSecret, Integer cell, Integer cellVersion) {
        super(true);
        this.agentSecret = agentSecret;
        this.agentServiceUrl = agentServiceUrl;
        this.agentUsername = agentUsername;
        this.cell = cell;
        this.cellVersion = cellVersion;
    }

    public Filter createInboundFilter(Context context) {
        AgentConfig agentConfig = new AgentConfig();
        agentConfig.setCell(this.cell);
        agentConfig.setCellVersion(this.cellVersion);
        agentConfig.setAgentServiceUrl(this.agentServiceUrl);
        agentConfig.setAgentUsername(this.agentUsername);
        agentConfig.setAgentSecret(this.agentSecret);
        return new AgentFilter(agentConfig, context);
    }

    public String getAgentSecret() {
        return new String(this.agentSecret);
    }

    public String getAgentServiceUrl() {
        return this.agentServiceUrl;
    }

    public String getAgentUsername() {
        return this.agentUsername;
    }

    public Integer getCell() {
        return this.cell;
    }

    public Integer getCellVersion() {
        return this.cellVersion;
    }

    public void setAgentSecret(String agentSecret) {
        this.agentSecret = agentSecret != null ? agentSecret.toCharArray() : null;
    }

    public void setAgentServiceUrl(String agentServiceUrl) {
        this.agentServiceUrl = agentServiceUrl;
    }

    public void setAgentUsername(String agentUsername) {
        this.agentUsername = agentUsername;
    }

    public void setCell(Integer cell) {
        this.cell = cell;
    }

    public void setCellVersion(Integer cellVersion) {
        this.cellVersion = cellVersion;
    }
}

