/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.restlet.Context;
import org.restlet.ext.apispark.internal.firewall.FirewallFilter;
import org.restlet.ext.apispark.internal.firewall.handler.BlockingHandler;
import org.restlet.ext.apispark.internal.firewall.handler.policy.RoleLimitPolicy;
import org.restlet.ext.apispark.internal.firewall.handler.policy.UniqueLimitPolicy;
import org.restlet.ext.apispark.internal.firewall.rule.ConcurrentFirewallCounterRule;
import org.restlet.ext.apispark.internal.firewall.rule.FirewallIpFilteringRule;
import org.restlet.ext.apispark.internal.firewall.rule.FirewallRule;
import org.restlet.ext.apispark.internal.firewall.rule.PeriodicFirewallCounterRule;
import org.restlet.ext.apispark.internal.firewall.rule.policy.HostDomainCountingPolicy;
import org.restlet.ext.apispark.internal.firewall.rule.policy.IpAddressCountingPolicy;
import org.restlet.ext.apispark.internal.firewall.rule.policy.UserCountingPolicy;
import org.restlet.routing.Filter;
import org.restlet.service.Service;

public class FirewallService
extends Service {
    private List<FirewallRule> rules = new ArrayList<FirewallRule>();

    public FirewallService() {
        this(true);
    }

    public FirewallService(boolean enabled) {
        super(enabled);
    }

    private void add(FirewallRule rule) {
        this.rules.add(rule);
    }

    public void addHostDomainConcurrencyCounter(int limit) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new HostDomainCountingPolicy());
        rule.addHandler(new BlockingHandler(new UniqueLimitPolicy(limit)));
        this.add(rule);
    }

    public void addHostDomainPeriodicCounter(int period, TimeUnit periodUnit, int limit) {
        PeriodicFirewallCounterRule rule = new PeriodicFirewallCounterRule(period, periodUnit, new HostDomainCountingPolicy());
        rule.addHandler(new BlockingHandler(new UniqueLimitPolicy(limit)));
    }

    public void addIpAddressesBlackList(List<String> blackList) {
        this.add(new FirewallIpFilteringRule(blackList, false));
    }

    public void addIpAddressesConcurrencyCounter(int limit) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new IpAddressCountingPolicy());
        rule.addHandler(new BlockingHandler(new UniqueLimitPolicy(limit)));
        this.add(rule);
    }

    public void addIpAddressesPeriodicCounter(int period, TimeUnit periodUnit, int limit) {
        PeriodicFirewallCounterRule rule = new PeriodicFirewallCounterRule(period, periodUnit, new IpAddressCountingPolicy());
        rule.addHandler(new BlockingHandler(new UniqueLimitPolicy(limit)));
        this.add(rule);
    }

    public void addIpAddressesWhiteList(List<String> whiteList) {
        this.add(new FirewallIpFilteringRule(whiteList, true));
    }

    public void addRolesConcurrencyCounter(Map<String, Integer> limitsPerRole) {
        this.addRolesConcurrencyCounter(limitsPerRole, 0);
    }

    public void addRolesConcurrencyCounter(Map<String, Integer> limitsPerRole, int defaultLimit) {
        ConcurrentFirewallCounterRule rule = new ConcurrentFirewallCounterRule(new UserCountingPolicy());
        rule.addHandler(new BlockingHandler(new RoleLimitPolicy(limitsPerRole, defaultLimit)));
        this.add(rule);
    }

    public void addRolesPeriodicCounter(int period, TimeUnit periodUnit, Map<String, Integer> limitsPerRole) {
        this.addRolesPeriodicCounter(period, periodUnit, limitsPerRole, 0);
    }

    public void addRolesPeriodicCounter(int period, TimeUnit periodUnit, Map<String, Integer> limitsPerRole, int defaultLimit) {
        PeriodicFirewallCounterRule rule = new PeriodicFirewallCounterRule(period, periodUnit, new UserCountingPolicy());
        rule.addHandler(new BlockingHandler(new RoleLimitPolicy(limitsPerRole, defaultLimit)));
        this.add(rule);
    }

    public Filter createInboundFilter(Context context) {
        return new FirewallFilter(context, this.rules);
    }
}

