/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.engine.Engine;
import org.restlet.engine.util.StringUtils;
import org.restlet.ext.apispark.internal.conversion.TranslationException;
import org.restlet.ext.apispark.internal.conversion.swagger.v1_2.SwaggerUtils;
import org.restlet.ext.apispark.internal.introspection.IntrospectionHelper;
import org.restlet.ext.apispark.internal.introspection.application.ApplicationIntrospector;
import org.restlet.ext.apispark.internal.introspection.application.ComponentIntrospector;
import org.restlet.ext.apispark.internal.introspection.jaxrs.JaxRsIntrospector;
import org.restlet.ext.apispark.internal.model.Definition;
import org.restlet.ext.apispark.internal.utils.IntrospectionUtils;
import org.restlet.ext.jaxrs.JaxRsApplication;

public class Introspector {
    private static Logger LOGGER = Context.getCurrentLogger();

    private static String getParameter(String[] args, int index) {
        if (index >= args.length) {
            return null;
        }
        String value = args[index];
        if ("-s".equals(value) || "-u".equals(value) || "-p".equals(value) || "-d".equals(value) || "-c".equals(value)) {
            value = null;
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws TranslationException {
        Definition definition;
        boolean create;
        boolean newVersion;
        String updateStrategy;
        String versionId;
        String descriptorId;
        String serviceUrl;
        String upwd;
        String ulogin;
        block32: {
            String language;
            String defSource;
            block33: {
                Engine.register();
                ulogin = null;
                upwd = null;
                serviceUrl = null;
                defSource = null;
                String compName = null;
                descriptorId = null;
                language = null;
                versionId = null;
                updateStrategy = null;
                ArrayList<IntrospectionHelper> introspectionHelpers = new ArrayList<IntrospectionHelper>();
                newVersion = false;
                create = false;
                LOGGER.fine("Get parameters");
                for (int i = 0; i < args.length; ++i) {
                    if ("-h".equals(args[i])) {
                        Introspector.printHelp();
                        System.exit(0);
                        continue;
                    }
                    if ("-u".equals(args[i]) || "--username".equals(args[i])) {
                        ulogin = Introspector.getParameter(args, ++i);
                        continue;
                    }
                    if ("-p".equals(args[i]) || "--password".equals(args[i])) {
                        upwd = Introspector.getParameter(args, ++i);
                        continue;
                    }
                    if ("-s".equals(args[i]) || "--service".equals(args[i])) {
                        serviceUrl = Introspector.getParameter(args, ++i);
                        continue;
                    }
                    if ("-c".equals(args[i]) || "--component".equals(args[i])) {
                        compName = Introspector.getParameter(args, ++i);
                        continue;
                    }
                    if ("-d".equals(args[i]) || "--descriptor".equals(args[i])) {
                        descriptorId = Introspector.getParameter(args, ++i);
                        continue;
                    }
                    if ("-v".equals(args[i]) || "--version".equals(args[i])) {
                        versionId = Introspector.getParameter(args, ++i);
                        continue;
                    }
                    if ("-U".equals(args[i]) || "--updateStrategy".equals(args[i])) {
                        updateStrategy = Introspector.getParameter(args, ++i).toLowerCase();
                        continue;
                    }
                    if ("-n".equals(args[i]) || "--newVersion".equals(args[i])) {
                        newVersion = true;
                        continue;
                    }
                    if ("-C".equals(args[i]) || "--create".equals(args[i])) {
                        create = true;
                        continue;
                    }
                    if ("-l".equals(args[i]) || "--language".equals(args[i])) {
                        language = Introspector.getParameter(args, ++i).toLowerCase();
                        continue;
                    }
                    if ("-V".equals(args[i]) || "--verbose".equals(args[i])) {
                        Engine.setLogLevel((Level)Level.FINE);
                        continue;
                    }
                    defSource = args[i];
                }
                ServiceLoader<IntrospectionHelper> ihLoader = ServiceLoader.load(IntrospectionHelper.class);
                for (IntrospectionHelper helper : ihLoader) {
                    introspectionHelpers.add(helper);
                }
                if (newVersion && create) {
                    LOGGER.severe("You can't use newVersion and create at the same time. Use parameter --help for help.");
                } else if (create && updateStrategy != null) {
                    LOGGER.severe("You can't use create and updateStrategy at the same time. Use parameter --help for help.");
                } else if (newVersion && updateStrategy != null) {
                    LOGGER.severe("You can't use newVersion and updateStrategy at the same time. Use parameter --help for help.");
                } else if (!newVersion && updateStrategy == null) {
                    create = true;
                }
                Engine.getLogger((String)"").getHandlers()[0].setFilter(new Filter(){

                    @Override
                    public boolean isLoggable(LogRecord record) {
                        return record.getLoggerName().startsWith("org.restlet.ext.apispark");
                    }
                });
                LOGGER.fine("Check parameters");
                if (StringUtils.isNullOrEmpty(serviceUrl)) {
                    serviceUrl = "https://apispark.com/";
                }
                if (!serviceUrl.endsWith("/")) {
                    serviceUrl = serviceUrl + "/";
                }
                if (StringUtils.isNullOrEmpty((String)ulogin) || StringUtils.isNullOrEmpty((String)upwd) || StringUtils.isNullOrEmpty(defSource)) {
                    Introspector.printHelp();
                    System.exit(1);
                }
                definition = null;
                if (language != null) break block33;
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(defSource);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.log(Level.SEVERE, "Cannot locate the application class.", e);
                    throw new RuntimeException("Cannot locate the application class.", e);
                }
                if (!JaxRsApplication.class.isAssignableFrom(clazz)) {
                    if (Application.class.isAssignableFrom(clazz)) {
                        Application application = ApplicationIntrospector.getApplication(defSource);
                        Component component = ComponentIntrospector.getComponent(compName);
                        definition = ApplicationIntrospector.getDefinition(application, null, component, introspectionHelpers);
                        break block32;
                    } else {
                        if (clazz == null) {
                            LOGGER.log(Level.SEVERE, "Class " + defSource + " is not supported");
                            throw new RuntimeException("Class " + defSource + " is not supported");
                        }
                        javax.ws.rs.core.Application jaxrsApplication = JaxRsIntrospector.getApplication(defSource);
                        definition = JaxRsIntrospector.getDefinition(jaxrsApplication, null, introspectionHelpers);
                    }
                }
                break block32;
            }
            if (!"swagger".equals(language)) {
                LOGGER.log(Level.SEVERE, "Language " + language + " is not supported");
                throw new RuntimeException("Language " + language + " is not supported");
            }
            definition = SwaggerUtils.getDefinition(defSource, ulogin, upwd);
        }
        if (definition != null) {
            IntrospectionUtils.sendDefinition(definition, descriptorId, versionId, ulogin, upwd, serviceUrl, updateStrategy, create, newVersion, LOGGER);
            return;
        }
        LOGGER.severe("Please provide a valid application class name or definition URL.");
    }

    private static void printHelp() {
        PrintStream o = System.out;
        o.println("SYNOPSIS");
        IntrospectionUtils.printSynopsis(o, Introspector.class, "[options] [--language swagger SWAGGER DEFINITION URL/PATH | APPLICATION]");
        IntrospectionUtils.printSynopsis(o, Introspector.class, "--create [options] [--language swagger SWAGGER DEFINITION URL/PATH | APPLICATION]");
        IntrospectionUtils.printSynopsis(o, Introspector.class, "--newVersion --descriptor descriptorId [options] [--language swagger SWAGGER DEFINITION URL/PATH | APPLICATION]");
        IntrospectionUtils.printSynopsis(o, Introspector.class, "--updateStrategy strategy --descriptor descriptorId --version versionId [options] [--language swagger SWAGGER DEFINITION URL/PATH | APPLICATION]");
        o.println("DESCRIPTION");
        IntrospectionUtils.printSentence(o, "Publish to the APISpark platform the description of your Web API, represented by APPLICATION,", "the full name of your Restlet or JAX-RS application class or by the Swagger definition available at ", "URL/PATH");
        IntrospectionUtils.printSentence(o, "If the whole process is successfull, it displays the url of the corresponding documentation.");
        o.println("OPTIONS");
        IntrospectionUtils.printOption(o, "-h, --help", "Prints this help.");
        IntrospectionUtils.printOption(o, "-u, --username username", "The mandatory APISpark user name.");
        IntrospectionUtils.printOption(o, "-p, --password password", "The mandatory APISpark user secret key.");
        IntrospectionUtils.printOption(o, "-c, --component commponent class", "The optional full name of your Restlet Component class.", "This allows to collect some other data, such as the endpoint.");
        IntrospectionUtils.printOption(o, "-C, --create", "Creates a new descriptor from introspection.", "Is set to true if neither --newVersion nor --updateStrategy are specified.");
        IntrospectionUtils.printOption(o, "-n, --newVersion", "Creates a new version of the descriptor identified by the --descriptor option");
        IntrospectionUtils.printOption(o, "-d, --descriptor descriptorId", "The optional identifier of an existing descriptor hosted by APISpark you want to update with this new documentation.", "Required if --updateStrategy or --newVersion options are specified.");
        IntrospectionUtils.printOption(o, "-U, --updateStrategy strategy", "Updates the descriptor version specified by the --descriptor and --version options with the given strategy. If no strategy is specified, the \"add\" strategy is selected by default. \n", "Strategies available:\n", "\"add\": new objects will be added to the APISpark's descriptor, primitive fields of existing objects will be updated. Nothing will be deleted.\n", "\"reset\": deletes all the information in the descriptor on APISpark's and fills it again with introspected definition.");
        IntrospectionUtils.printOption(o, "-v, --version versionId", "The version of the descriptor to be updated. Required if --updateStrategy is specified.");
        IntrospectionUtils.printOption(o, "-l, --language languageName", "The optional name of the description language of the definition you want to upload. Possible value: \"swagger\"");
        IntrospectionUtils.printOption(o, "-v, --verbose", "The optional parameter switching the process to a verbose mode");
        o.println("ENHANCE INTROSPECTION");
        IntrospectionUtils.printSentence(o, "You can extend the basic introspection and enrich the generated documentation by providing dedicated helpers to the introspector.", "For example, if you are using Swagger annotations inside your code, complete the classpath by adding the jar either ", "of the org.restlet.ext.apispark-swagger-annotation-2_0 extension or the the org.restlet.ext.apispark-swagger-annotation-1_2 extension. \n");
    }
}

