/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.agent;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.ext.apispark.internal.agent.AgentConfig;
import org.restlet.ext.apispark.internal.agent.AgentConfigurationException;
import org.restlet.ext.apispark.internal.agent.AgentModulesConfigurer;
import org.restlet.ext.apispark.internal.agent.bean.ModulesSettings;
import org.restlet.ext.apispark.internal.agent.module.AnalyticsModule;
import org.restlet.ext.apispark.internal.agent.module.AuthenticationModule;
import org.restlet.ext.apispark.internal.agent.module.AuthorizationModule;
import org.restlet.ext.apispark.internal.agent.module.FirewallModule;
import org.restlet.routing.Filter;

public class AgentModulesHelper {
    protected static Logger LOGGER = Logger.getLogger(AgentModulesHelper.class.getName());

    public static AgentModulesConfigurer buildFromSettings(AgentConfig agentConfig, ModulesSettings modulesSettings, Context context) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (modulesSettings.isAuthenticationModuleEnabled()) {
            LOGGER.info("Add authentication module");
            filters.add((Filter)new AuthenticationModule(agentConfig, modulesSettings, context));
        }
        if (modulesSettings.isAuthorizationModuleEnabled()) {
            if (!modulesSettings.isAuthenticationModuleEnabled()) {
                throw new AgentConfigurationException("The authorization module requires the authentication module which is not enabled");
            }
            LOGGER.info("Add authorization module");
            filters.add(new AuthorizationModule(agentConfig, modulesSettings, context));
        }
        if (modulesSettings.isFirewallModuleEnabled()) {
            LOGGER.info("Add firewall module");
            filters.add(new FirewallModule(agentConfig, modulesSettings, context));
        }
        if (modulesSettings.isAnalyticsModuleEnabled()) {
            LOGGER.info("Add analytics module");
            filters.add(new AnalyticsModule(agentConfig, modulesSettings, context));
        }
        if (filters.isEmpty()) {
            LOGGER.warning("No modules are enabled.");
        }
        return new AgentModulesConfigurer(filters);
    }
}

