/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.agent;

import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.ext.apispark.internal.agent.AgentConfig;
import org.restlet.ext.apispark.internal.agent.bean.ModulesSettings;
import org.restlet.resource.ClientResource;
import org.restlet.util.Series;

public abstract class AgentUtils {
    public static <T> T getClientResource(AgentConfig agentConfig, ModulesSettings modulesSettings, Class<T> resourceClass, String resourcePath) {
        StringBuilder sb = new StringBuilder(agentConfig.getAgentServiceUrl());
        if (!agentConfig.getAgentServiceUrl().endsWith("/")) {
            sb.append("/");
        }
        sb.append("agent");
        sb.append("/cells/");
        sb.append(agentConfig.getCell());
        sb.append("/versions/");
        sb.append(agentConfig.getCellVersion());
        if (resourcePath != null) {
            if (!resourcePath.startsWith("/")) {
                sb.append("/");
            }
            sb.append(resourcePath);
        }
        ClientResource clientResource = new ClientResource(sb.toString());
        clientResource.accept(new Metadata[]{MediaType.APPLICATION_JSON});
        clientResource.setChallengeResponse(ChallengeScheme.HTTP_BASIC, agentConfig.getAgentUsername(), agentConfig.getAgentSecret());
        Series headers = clientResource.getRequest().getHeaders();
        headers.add("x-restlet-connector-agent-version", "1.0");
        if (modulesSettings != null) {
            headers.add("x-restlet-connector-cell-revision", modulesSettings.getCellRevision());
        }
        return (T)clientResource.wrap(resourceClass);
    }

    private AgentUtils() {
    }
}

