/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.agent.module;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.ext.apispark.FirewallService;
import org.restlet.ext.apispark.internal.agent.AgentConfig;
import org.restlet.ext.apispark.internal.agent.AgentConfigurationException;
import org.restlet.ext.apispark.internal.agent.AgentUtils;
import org.restlet.ext.apispark.internal.agent.bean.FirewallIpFilter;
import org.restlet.ext.apispark.internal.agent.bean.FirewallRateLimit;
import org.restlet.ext.apispark.internal.agent.bean.FirewallSettings;
import org.restlet.ext.apispark.internal.agent.bean.ModulesSettings;
import org.restlet.ext.apispark.internal.agent.resource.FirewallSettingsResource;
import org.restlet.ext.apispark.internal.firewall.FirewallFilter;
import org.restlet.routing.Filter;

public class FirewallModule
extends Filter {
    public static final String MODULE_PATH = "/firewall";
    public static final String SETTINGS_PATH = "/firewall/settings";
    private final FirewallFilter firewallFilter;

    public FirewallModule(AgentConfig agentConfig, ModulesSettings modulesSettings) {
        this(agentConfig, modulesSettings, null);
    }

    public FirewallModule(AgentConfig agentConfig, ModulesSettings modulesSettings, Context context) {
        super(context);
        FirewallSettings firewallSettings;
        FirewallSettingsResource firewallSettingsClientResource = AgentUtils.getClientResource(agentConfig, modulesSettings, FirewallSettingsResource.class, SETTINGS_PATH);
        try {
            firewallSettings = firewallSettingsClientResource.getSettings();
        }
        catch (Exception e) {
            throw new AgentConfigurationException("Could not get firewall module configuration from APISpark connector service", e);
        }
        this.firewallFilter = this.createFirewallFilter(firewallSettings);
    }

    private void addIpFilterRules(FirewallSettings firewallSettings, FirewallService firewallService) {
        if (firewallSettings.getIpFilters() != null) {
            for (FirewallIpFilter ipFilter : firewallSettings.getIpFilters()) {
                if (ipFilter.isWhiteList()) {
                    firewallService.addIpAddressesWhiteList(ipFilter.getIps());
                    continue;
                }
                firewallService.addIpAddressesBlackList(ipFilter.getIps());
            }
        }
    }

    private void addRateLimitationRules(FirewallSettings firewallSettings, FirewallService firewallService) {
        if (firewallSettings.getRateLimits() != null) {
            List<FirewallRateLimit> rateLimits = firewallSettings.getRateLimits();
            Map<Integer, Collection<FirewallRateLimit>> rateLimitsByPeriod = this.sortRateLimitsByPeriod(rateLimits);
            for (Integer period : rateLimitsByPeriod.keySet()) {
                HashMap<String, Integer> limitsPerRole = new HashMap<String, Integer>();
                int defaultRateLimit = Integer.MAX_VALUE;
                for (FirewallRateLimit firewallRateLimit : rateLimitsByPeriod.get(period)) {
                    if (firewallRateLimit.isDefaultRateLimit()) {
                        defaultRateLimit = firewallRateLimit.getRateLimit();
                        continue;
                    }
                    limitsPerRole.put(firewallRateLimit.getGroup(), firewallRateLimit.getRateLimit());
                }
                firewallService.addRolesPeriodicCounter(period, TimeUnit.SECONDS, limitsPerRole, defaultRateLimit);
            }
        }
    }

    protected void afterHandle(Request request, Response response) {
        this.firewallFilter.afterHandle(request, response);
    }

    protected int beforeHandle(Request request, Response response) {
        return this.firewallFilter.beforeHandle(request, response);
    }

    private FirewallFilter createFirewallFilter(FirewallSettings firewallSettings) {
        FirewallService firewallService = new FirewallService();
        this.addIpFilterRules(firewallSettings, firewallService);
        this.addRateLimitationRules(firewallSettings, firewallService);
        return (FirewallFilter)firewallService.createInboundFilter(this.getContext());
    }

    private Map<Integer, Collection<FirewallRateLimit>> sortRateLimitsByPeriod(List<FirewallRateLimit> rateLimits) {
        ImmutableListMultimap rateLimitsByPeriod = Multimaps.index(rateLimits, (Function)new Function<FirewallRateLimit, Integer>(){

            public Integer apply(FirewallRateLimit firewallRateLimit) {
                return firewallRateLimit.getPeriod();
            }
        });
        return rateLimitsByPeriod.asMap();
    }
}

