/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.apispark.internal.conversion.raml;

import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.SimpleTypeSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.model.ActionType;
import org.raml.model.ParamType;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.visitor.RamlValidationService;
import org.restlet.ext.apispark.internal.conversion.TranslationException;
import org.restlet.ext.apispark.internal.model.Property;
import org.restlet.ext.apispark.internal.model.Representation;

public class RamlUtils {
    private static final List<String> integerTypesList = Arrays.asList("integer", "int");
    private static final List<String> numericTypesList = Arrays.asList("integer", "int", "double", "long", "float");

    public static String capFirst(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return ("" + str.charAt(0)).toUpperCase() + str.substring(1);
    }

    protected static SimpleTypeSchema generatePrimitiveSchema(Property property) {
        String type;
        IntegerSchema result = null;
        String name = property.getName();
        String string = type = property.getType() != null ? property.getType().toLowerCase() : null;
        if (integerTypesList.contains(type)) {
            IntegerSchema integerSchema = new IntegerSchema();
            integerSchema.setTitle(name);
            if (property.getMin() != null) {
                integerSchema.setMinimum(Double.valueOf(Double.parseDouble(property.getMin())));
            }
            if (property.getMax() != null) {
                integerSchema.setMaximum(Double.valueOf(Double.parseDouble(property.getMax())));
            }
            result = integerSchema;
        } else if (numericTypesList.contains(type)) {
            NumberSchema numberSchema = new NumberSchema();
            numberSchema.setTitle(name);
            if (property.getMin() != null) {
                numberSchema.setMinimum(Double.valueOf(Double.parseDouble(property.getMin())));
            }
            if (property.getMax() != null) {
                numberSchema.setMaximum(Double.valueOf(Double.parseDouble(property.getMax())));
            }
            result = numberSchema;
        } else if ("boolean".equals(type)) {
            BooleanSchema booleanSchema = new BooleanSchema();
            booleanSchema.setTitle(name);
            result = booleanSchema;
        } else if ("string".equals(type) || "date".equals(type)) {
            StringSchema stringSchema = new StringSchema();
            stringSchema.setTitle(name);
            result = stringSchema;
        }
        return result;
    }

    public static JsonSchema generateSchema(Representation representation) {
        ObjectSchema objectSchema = new ObjectSchema();
        objectSchema.setTitle(representation.getIdentifier());
        objectSchema.setDescription(representation.getDescription());
        if (!representation.isRaw()) {
            if (representation.getExtendedType() != null) {
                JsonSchema[] extended = new JsonSchema[1];
                ObjectSchema typeExtended = new ObjectSchema();
                typeExtended.set$ref(representation.getExtendedType());
                extended[0] = typeExtended;
                objectSchema.setExtends(extended);
            }
            objectSchema.setProperties(new HashMap());
            for (Property property : representation.getProperties()) {
                if (property.getMaxOccurs() != 1) {
                    ArraySchema array = new ArraySchema();
                    array.setTitle(property.getName());
                    array.setRequired(Boolean.valueOf(property.getMinOccurs() > 0));
                    array.setUniqueItems(Boolean.valueOf(property.isUniqueItems()));
                    if (RamlUtils.isPrimitiveType(property.getType())) {
                        Property prop = new Property();
                        prop.setName(property.getName());
                        prop.setType(property.getType());
                        array.setItemsSchema((JsonSchema)RamlUtils.generatePrimitiveSchema(prop));
                    } else {
                        ObjectSchema reference = new ObjectSchema();
                        reference.set$ref("#/schemas/" + property.getType());
                        array.setItemsSchema((JsonSchema)reference);
                    }
                    objectSchema.getProperties().put(array.getTitle(), array);
                    continue;
                }
                if (!RamlUtils.isPrimitiveType(property.getType())) {
                    ObjectSchema propertySchema = new ObjectSchema();
                    propertySchema.setTitle(property.getName());
                    propertySchema.set$ref("#/schemas/" + property.getType());
                    propertySchema.setRequired(Boolean.valueOf(property.getMinOccurs() > 0));
                    objectSchema.getProperties().put(propertySchema.getTitle(), propertySchema);
                    continue;
                }
                SimpleTypeSchema primitive = RamlUtils.generatePrimitiveSchema(property);
                primitive.setRequired(Boolean.valueOf(property.getMinOccurs() > 0));
                if (property.getDefaultValue() != null) {
                    primitive.setDefault(property.getDefaultValue());
                }
                objectSchema.getProperties().put(property.getName(), primitive);
            }
        }
        return objectSchema;
    }

    public static ActionType getActionType(String method) {
        String m;
        String string = m = method != null ? method.toLowerCase() : null;
        if ("post".equals(m)) {
            return ActionType.POST;
        }
        if ("get".equals(m)) {
            return ActionType.GET;
        }
        if ("put".equals(m)) {
            return ActionType.PUT;
        }
        if ("patch".equals(m)) {
            return ActionType.PATCH;
        }
        if ("delete".equals(m)) {
            return ActionType.DELETE;
        }
        if ("head".equals(m)) {
            return ActionType.HEAD;
        }
        if ("options".equals(m)) {
            return ActionType.OPTIONS;
        }
        if ("trace".equals(m)) {
            return ActionType.TRACE;
        }
        return null;
    }

    public static ParamType getParamType(String type) {
        String t;
        String string = t = type != null ? type.toLowerCase() : null;
        if (integerTypesList.contains(t)) {
            return ParamType.INTEGER;
        }
        if (numericTypesList.contains(t)) {
            return ParamType.NUMBER;
        }
        if ("boolean".equals(t)) {
            return ParamType.BOOLEAN;
        }
        if ("date".equals(t)) {
            return ParamType.DATE;
        }
        return ParamType.STRING;
    }

    public static Resource getParentResource(List<String> paths, String resourcePath, Raml raml) {
        String parentPath;
        ArrayList<String> parentPaths = new ArrayList<String>();
        parentPaths.addAll(paths);
        parentPaths.add(resourcePath);
        Collections.sort(parentPaths);
        int index = parentPaths.indexOf(resourcePath);
        if (index != 0 && resourcePath.startsWith(parentPath = (String)parentPaths.get(index - 1))) {
            return RamlUtils.getResourceByCompletePath(raml, parentPath);
        }
        return null;
    }

    private static Resource getResourceByCompletePath(Raml raml, String path) {
        for (Map.Entry entry : raml.getResources().entrySet()) {
            if (!path.equals(((Resource)entry.getValue()).getParentUri() + ((Resource)entry.getValue()).getRelativeUri())) continue;
            return (Resource)entry.getValue();
        }
        return null;
    }

    public static boolean isPrimitiveType(String type) {
        String t = type != null ? type.toLowerCase() : null;
        return "string".equals(t) || "int".equals(t) || "integer".equals(t) || "long".equals(t) || "float".equals(t) || "double".equals(t) || "date".equals(t) || "boolean".equals(t) || "bool".equals(t);
    }

    public static String processResourceName(String uri) {
        String[] split;
        String processedUri = "";
        for (String str : split = uri.replaceAll("\\{", "").replaceAll("\\}", "").split("/")) {
            processedUri = processedUri + RamlUtils.capFirst(str);
        }
        return processedUri;
    }

    public static String toRamlType(String type) {
        if ("Integer".equals(type)) {
            return "int";
        }
        if ("String".equals(type)) {
            return "string";
        }
        if ("Boolean".equals(type)) {
            return "boolean";
        }
        return type;
    }

    public static List<ValidationResult> validate(String location) throws TranslationException {
        return RamlValidationService.createDefault().validate(location);
    }
}

